package microsoft.vs.analytics.v2.model.entity;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import microsoft.vs.analytics.v2.model.entity.collection.request.TeamCollectionRequest;
import microsoft.vs.analytics.v2.model.entity.request.ProjectRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "ProjectSK", 
    "AreaSK", 
    "AreaId", 
    "AreaName", 
    "Number", 
    "AreaPath", 
    "AreaLevel1", 
    "AreaLevel2", 
    "AreaLevel3", 
    "AreaLevel4", 
    "AreaLevel5", 
    "AreaLevel6", 
    "AreaLevel7", 
    "AreaLevel8", 
    "AreaLevel9", 
    "AreaLevel10", 
    "AreaLevel11", 
    "AreaLevel12", 
    "AreaLevel13", 
    "AreaLevel14", 
    "Depth"})
@JsonInclude(Include.NON_NULL)
public class Area implements ODataEntityType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JacksonInject
    @JsonIgnore
    protected ChangedFields changedFields;

    @Override
    public String odataTypeName() {
        return "Microsoft.VisualStudio.Services.Analytics.Model.Area";
    }

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("ProjectSK")
    protected String projectSK;

    @JsonProperty("AreaSK")
    protected String areaSK;

    @JsonProperty("AreaId")
    protected String areaId;

    @JsonProperty("AreaName")
    protected String areaName;

    @JsonProperty("Number")
    protected Integer number;

    @JsonProperty("AreaPath")
    protected String areaPath;

    @JsonProperty("AreaLevel1")
    protected String areaLevel1;

    @JsonProperty("AreaLevel2")
    protected String areaLevel2;

    @JsonProperty("AreaLevel3")
    protected String areaLevel3;

    @JsonProperty("AreaLevel4")
    protected String areaLevel4;

    @JsonProperty("AreaLevel5")
    protected String areaLevel5;

    @JsonProperty("AreaLevel6")
    protected String areaLevel6;

    @JsonProperty("AreaLevel7")
    protected String areaLevel7;

    @JsonProperty("AreaLevel8")
    protected String areaLevel8;

    @JsonProperty("AreaLevel9")
    protected String areaLevel9;

    @JsonProperty("AreaLevel10")
    protected String areaLevel10;

    @JsonProperty("AreaLevel11")
    protected String areaLevel11;

    @JsonProperty("AreaLevel12")
    protected String areaLevel12;

    @JsonProperty("AreaLevel13")
    protected String areaLevel13;

    @JsonProperty("AreaLevel14")
    protected String areaLevel14;

    @JsonProperty("Depth")
    protected Integer depth;

    protected Area() {
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String projectSK;
        private String areaSK;
        private String areaId;
        private String areaName;
        private Integer number;
        private String areaPath;
        private String areaLevel1;
        private String areaLevel2;
        private String areaLevel3;
        private String areaLevel4;
        private String areaLevel5;
        private String areaLevel6;
        private String areaLevel7;
        private String areaLevel8;
        private String areaLevel9;
        private String areaLevel10;
        private String areaLevel11;
        private String areaLevel12;
        private String areaLevel13;
        private String areaLevel14;
        private Integer depth;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder projectSK(String projectSK) {
            this.projectSK = projectSK;
            this.changedFields = changedFields.add("ProjectSK");
            return this;
        }

        public Builder areaSK(String areaSK) {
            this.areaSK = areaSK;
            this.changedFields = changedFields.add("AreaSK");
            return this;
        }

        public Builder areaId(String areaId) {
            this.areaId = areaId;
            this.changedFields = changedFields.add("AreaId");
            return this;
        }

        public Builder areaName(String areaName) {
            this.areaName = areaName;
            this.changedFields = changedFields.add("AreaName");
            return this;
        }

        public Builder number(Integer number) {
            this.number = number;
            this.changedFields = changedFields.add("Number");
            return this;
        }

        public Builder areaPath(String areaPath) {
            this.areaPath = areaPath;
            this.changedFields = changedFields.add("AreaPath");
            return this;
        }

        public Builder areaLevel1(String areaLevel1) {
            this.areaLevel1 = areaLevel1;
            this.changedFields = changedFields.add("AreaLevel1");
            return this;
        }

        public Builder areaLevel2(String areaLevel2) {
            this.areaLevel2 = areaLevel2;
            this.changedFields = changedFields.add("AreaLevel2");
            return this;
        }

        public Builder areaLevel3(String areaLevel3) {
            this.areaLevel3 = areaLevel3;
            this.changedFields = changedFields.add("AreaLevel3");
            return this;
        }

        public Builder areaLevel4(String areaLevel4) {
            this.areaLevel4 = areaLevel4;
            this.changedFields = changedFields.add("AreaLevel4");
            return this;
        }

        public Builder areaLevel5(String areaLevel5) {
            this.areaLevel5 = areaLevel5;
            this.changedFields = changedFields.add("AreaLevel5");
            return this;
        }

        public Builder areaLevel6(String areaLevel6) {
            this.areaLevel6 = areaLevel6;
            this.changedFields = changedFields.add("AreaLevel6");
            return this;
        }

        public Builder areaLevel7(String areaLevel7) {
            this.areaLevel7 = areaLevel7;
            this.changedFields = changedFields.add("AreaLevel7");
            return this;
        }

        public Builder areaLevel8(String areaLevel8) {
            this.areaLevel8 = areaLevel8;
            this.changedFields = changedFields.add("AreaLevel8");
            return this;
        }

        public Builder areaLevel9(String areaLevel9) {
            this.areaLevel9 = areaLevel9;
            this.changedFields = changedFields.add("AreaLevel9");
            return this;
        }

        public Builder areaLevel10(String areaLevel10) {
            this.areaLevel10 = areaLevel10;
            this.changedFields = changedFields.add("AreaLevel10");
            return this;
        }

        public Builder areaLevel11(String areaLevel11) {
            this.areaLevel11 = areaLevel11;
            this.changedFields = changedFields.add("AreaLevel11");
            return this;
        }

        public Builder areaLevel12(String areaLevel12) {
            this.areaLevel12 = areaLevel12;
            this.changedFields = changedFields.add("AreaLevel12");
            return this;
        }

        public Builder areaLevel13(String areaLevel13) {
            this.areaLevel13 = areaLevel13;
            this.changedFields = changedFields.add("AreaLevel13");
            return this;
        }

        public Builder areaLevel14(String areaLevel14) {
            this.areaLevel14 = areaLevel14;
            this.changedFields = changedFields.add("AreaLevel14");
            return this;
        }

        public Builder depth(Integer depth) {
            this.depth = depth;
            this.changedFields = changedFields.add("Depth");
            return this;
        }

        public Area build() {
            Area _x = new Area();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.VisualStudio.Services.Analytics.Model.Area";
            _x.projectSK = projectSK;
            _x.areaSK = areaSK;
            _x.areaId = areaId;
            _x.areaName = areaName;
            _x.number = number;
            _x.areaPath = areaPath;
            _x.areaLevel1 = areaLevel1;
            _x.areaLevel2 = areaLevel2;
            _x.areaLevel3 = areaLevel3;
            _x.areaLevel4 = areaLevel4;
            _x.areaLevel5 = areaLevel5;
            _x.areaLevel6 = areaLevel6;
            _x.areaLevel7 = areaLevel7;
            _x.areaLevel8 = areaLevel8;
            _x.areaLevel9 = areaLevel9;
            _x.areaLevel10 = areaLevel10;
            _x.areaLevel11 = areaLevel11;
            _x.areaLevel12 = areaLevel12;
            _x.areaLevel13 = areaLevel13;
            _x.areaLevel14 = areaLevel14;
            _x.depth = depth;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && areaSK != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(areaSK.toString()));
        }
    }

    @Property(name="ProjectSK")
    @JsonIgnore
    public Optional<String> getProjectSK() {
        return Optional.ofNullable(projectSK);
    }

    public Area withProjectSK(String projectSK) {
        Area _x = _copy();
        _x.changedFields = changedFields.add("ProjectSK");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.Area");
        _x.projectSK = projectSK;
        return _x;
    }

    @Property(name="AreaSK")
    @JsonIgnore
    public Optional<String> getAreaSK() {
        return Optional.ofNullable(areaSK);
    }

    public Area withAreaSK(String areaSK) {
        Area _x = _copy();
        _x.changedFields = changedFields.add("AreaSK");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.Area");
        _x.areaSK = areaSK;
        return _x;
    }

    @Property(name="AreaId")
    @JsonIgnore
    public Optional<String> getAreaId() {
        return Optional.ofNullable(areaId);
    }

    public Area withAreaId(String areaId) {
        Area _x = _copy();
        _x.changedFields = changedFields.add("AreaId");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.Area");
        _x.areaId = areaId;
        return _x;
    }

    @Property(name="AreaName")
    @JsonIgnore
    public Optional<String> getAreaName() {
        return Optional.ofNullable(areaName);
    }

    public Area withAreaName(String areaName) {
        Area _x = _copy();
        _x.changedFields = changedFields.add("AreaName");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.Area");
        _x.areaName = areaName;
        return _x;
    }

    @Property(name="Number")
    @JsonIgnore
    public Optional<Integer> getNumber() {
        return Optional.ofNullable(number);
    }

    public Area withNumber(Integer number) {
        Area _x = _copy();
        _x.changedFields = changedFields.add("Number");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.Area");
        _x.number = number;
        return _x;
    }

    @Property(name="AreaPath")
    @JsonIgnore
    public Optional<String> getAreaPath() {
        return Optional.ofNullable(areaPath);
    }

    public Area withAreaPath(String areaPath) {
        Area _x = _copy();
        _x.changedFields = changedFields.add("AreaPath");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.Area");
        _x.areaPath = areaPath;
        return _x;
    }

    @Property(name="AreaLevel1")
    @JsonIgnore
    public Optional<String> getAreaLevel1() {
        return Optional.ofNullable(areaLevel1);
    }

    public Area withAreaLevel1(String areaLevel1) {
        Area _x = _copy();
        _x.changedFields = changedFields.add("AreaLevel1");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.Area");
        _x.areaLevel1 = areaLevel1;
        return _x;
    }

    @Property(name="AreaLevel2")
    @JsonIgnore
    public Optional<String> getAreaLevel2() {
        return Optional.ofNullable(areaLevel2);
    }

    public Area withAreaLevel2(String areaLevel2) {
        Area _x = _copy();
        _x.changedFields = changedFields.add("AreaLevel2");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.Area");
        _x.areaLevel2 = areaLevel2;
        return _x;
    }

    @Property(name="AreaLevel3")
    @JsonIgnore
    public Optional<String> getAreaLevel3() {
        return Optional.ofNullable(areaLevel3);
    }

    public Area withAreaLevel3(String areaLevel3) {
        Area _x = _copy();
        _x.changedFields = changedFields.add("AreaLevel3");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.Area");
        _x.areaLevel3 = areaLevel3;
        return _x;
    }

    @Property(name="AreaLevel4")
    @JsonIgnore
    public Optional<String> getAreaLevel4() {
        return Optional.ofNullable(areaLevel4);
    }

    public Area withAreaLevel4(String areaLevel4) {
        Area _x = _copy();
        _x.changedFields = changedFields.add("AreaLevel4");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.Area");
        _x.areaLevel4 = areaLevel4;
        return _x;
    }

    @Property(name="AreaLevel5")
    @JsonIgnore
    public Optional<String> getAreaLevel5() {
        return Optional.ofNullable(areaLevel5);
    }

    public Area withAreaLevel5(String areaLevel5) {
        Area _x = _copy();
        _x.changedFields = changedFields.add("AreaLevel5");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.Area");
        _x.areaLevel5 = areaLevel5;
        return _x;
    }

    @Property(name="AreaLevel6")
    @JsonIgnore
    public Optional<String> getAreaLevel6() {
        return Optional.ofNullable(areaLevel6);
    }

    public Area withAreaLevel6(String areaLevel6) {
        Area _x = _copy();
        _x.changedFields = changedFields.add("AreaLevel6");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.Area");
        _x.areaLevel6 = areaLevel6;
        return _x;
    }

    @Property(name="AreaLevel7")
    @JsonIgnore
    public Optional<String> getAreaLevel7() {
        return Optional.ofNullable(areaLevel7);
    }

    public Area withAreaLevel7(String areaLevel7) {
        Area _x = _copy();
        _x.changedFields = changedFields.add("AreaLevel7");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.Area");
        _x.areaLevel7 = areaLevel7;
        return _x;
    }

    @Property(name="AreaLevel8")
    @JsonIgnore
    public Optional<String> getAreaLevel8() {
        return Optional.ofNullable(areaLevel8);
    }

    public Area withAreaLevel8(String areaLevel8) {
        Area _x = _copy();
        _x.changedFields = changedFields.add("AreaLevel8");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.Area");
        _x.areaLevel8 = areaLevel8;
        return _x;
    }

    @Property(name="AreaLevel9")
    @JsonIgnore
    public Optional<String> getAreaLevel9() {
        return Optional.ofNullable(areaLevel9);
    }

    public Area withAreaLevel9(String areaLevel9) {
        Area _x = _copy();
        _x.changedFields = changedFields.add("AreaLevel9");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.Area");
        _x.areaLevel9 = areaLevel9;
        return _x;
    }

    @Property(name="AreaLevel10")
    @JsonIgnore
    public Optional<String> getAreaLevel10() {
        return Optional.ofNullable(areaLevel10);
    }

    public Area withAreaLevel10(String areaLevel10) {
        Area _x = _copy();
        _x.changedFields = changedFields.add("AreaLevel10");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.Area");
        _x.areaLevel10 = areaLevel10;
        return _x;
    }

    @Property(name="AreaLevel11")
    @JsonIgnore
    public Optional<String> getAreaLevel11() {
        return Optional.ofNullable(areaLevel11);
    }

    public Area withAreaLevel11(String areaLevel11) {
        Area _x = _copy();
        _x.changedFields = changedFields.add("AreaLevel11");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.Area");
        _x.areaLevel11 = areaLevel11;
        return _x;
    }

    @Property(name="AreaLevel12")
    @JsonIgnore
    public Optional<String> getAreaLevel12() {
        return Optional.ofNullable(areaLevel12);
    }

    public Area withAreaLevel12(String areaLevel12) {
        Area _x = _copy();
        _x.changedFields = changedFields.add("AreaLevel12");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.Area");
        _x.areaLevel12 = areaLevel12;
        return _x;
    }

    @Property(name="AreaLevel13")
    @JsonIgnore
    public Optional<String> getAreaLevel13() {
        return Optional.ofNullable(areaLevel13);
    }

    public Area withAreaLevel13(String areaLevel13) {
        Area _x = _copy();
        _x.changedFields = changedFields.add("AreaLevel13");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.Area");
        _x.areaLevel13 = areaLevel13;
        return _x;
    }

    @Property(name="AreaLevel14")
    @JsonIgnore
    public Optional<String> getAreaLevel14() {
        return Optional.ofNullable(areaLevel14);
    }

    public Area withAreaLevel14(String areaLevel14) {
        Area _x = _copy();
        _x.changedFields = changedFields.add("AreaLevel14");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.Area");
        _x.areaLevel14 = areaLevel14;
        return _x;
    }

    @Property(name="Depth")
    @JsonIgnore
    public Optional<Integer> getDepth() {
        return Optional.ofNullable(depth);
    }

    public Area withDepth(Integer depth) {
        Area _x = _copy();
        _x.changedFields = changedFields.add("Depth");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.Area");
        _x.depth = depth;
        return _x;
    }

    public Area withUnmappedField(String name, String value) {
        Area _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="Project")
    @JsonIgnore
    public ProjectRequest getProject() {
        return new ProjectRequest(contextPath.addSegment("Project"), RequestHelper.getValue(unmappedFields, "Project"));
    }

    @NavigationProperty(name="Teams")
    @JsonIgnore
    public TeamCollectionRequest getTeams() {
        return new TeamCollectionRequest(
                        contextPath.addSegment("Teams"), RequestHelper.getValue(unmappedFields, "Teams"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Area patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Area _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Area put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Area _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Area _copy() {
        Area _x = new Area();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.projectSK = projectSK;
        _x.areaSK = areaSK;
        _x.areaId = areaId;
        _x.areaName = areaName;
        _x.number = number;
        _x.areaPath = areaPath;
        _x.areaLevel1 = areaLevel1;
        _x.areaLevel2 = areaLevel2;
        _x.areaLevel3 = areaLevel3;
        _x.areaLevel4 = areaLevel4;
        _x.areaLevel5 = areaLevel5;
        _x.areaLevel6 = areaLevel6;
        _x.areaLevel7 = areaLevel7;
        _x.areaLevel8 = areaLevel8;
        _x.areaLevel9 = areaLevel9;
        _x.areaLevel10 = areaLevel10;
        _x.areaLevel11 = areaLevel11;
        _x.areaLevel12 = areaLevel12;
        _x.areaLevel13 = areaLevel13;
        _x.areaLevel14 = areaLevel14;
        _x.depth = depth;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Area[");
        b.append("ProjectSK=");
        b.append(this.projectSK);
        b.append(", ");
        b.append("AreaSK=");
        b.append(this.areaSK);
        b.append(", ");
        b.append("AreaId=");
        b.append(this.areaId);
        b.append(", ");
        b.append("AreaName=");
        b.append(this.areaName);
        b.append(", ");
        b.append("Number=");
        b.append(this.number);
        b.append(", ");
        b.append("AreaPath=");
        b.append(this.areaPath);
        b.append(", ");
        b.append("AreaLevel1=");
        b.append(this.areaLevel1);
        b.append(", ");
        b.append("AreaLevel2=");
        b.append(this.areaLevel2);
        b.append(", ");
        b.append("AreaLevel3=");
        b.append(this.areaLevel3);
        b.append(", ");
        b.append("AreaLevel4=");
        b.append(this.areaLevel4);
        b.append(", ");
        b.append("AreaLevel5=");
        b.append(this.areaLevel5);
        b.append(", ");
        b.append("AreaLevel6=");
        b.append(this.areaLevel6);
        b.append(", ");
        b.append("AreaLevel7=");
        b.append(this.areaLevel7);
        b.append(", ");
        b.append("AreaLevel8=");
        b.append(this.areaLevel8);
        b.append(", ");
        b.append("AreaLevel9=");
        b.append(this.areaLevel9);
        b.append(", ");
        b.append("AreaLevel10=");
        b.append(this.areaLevel10);
        b.append(", ");
        b.append("AreaLevel11=");
        b.append(this.areaLevel11);
        b.append(", ");
        b.append("AreaLevel12=");
        b.append(this.areaLevel12);
        b.append(", ");
        b.append("AreaLevel13=");
        b.append(this.areaLevel13);
        b.append(", ");
        b.append("AreaLevel14=");
        b.append(this.areaLevel14);
        b.append(", ");
        b.append("Depth=");
        b.append(this.depth);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
