package microsoft.vs.analytics.v1.model.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum UserType implements Enum {

    @JsonProperty("Unknown")
    UNKNOWN("Unknown", "0"),

    @JsonProperty("Unrecognized")
    UNRECOGNIZED("Unrecognized", "1"),

    @JsonProperty("User")
    USER("User", "2"),

    @JsonProperty("Organization")
    ORGANIZATION("Organization", "3"),

    @JsonProperty("Bot")
    BOT("Bot", "4");

    private final String name;
    private final String value;

    private UserType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
