package microsoft.vs.analytics.v1.model.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import java.lang.Object;
import java.util.Optional;

import microsoft.vs.analytics.v1.model.entity.WorkItemTypeField;

@JsonIgnoreType
public class WorkItemTypeFieldRequest extends EntityRequest<WorkItemTypeField> {

    public WorkItemTypeFieldRequest(ContextPath contextPath, Optional<Object> value) {
        super(WorkItemTypeField.class, contextPath, value, false);
    }

    public ProjectRequest project() {
        return new ProjectRequest(contextPath.addSegment("Project"), Optional.empty());
    }

}
