package microsoft.vs.analytics.v1.model.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import java.lang.Object;
import java.util.Optional;

import microsoft.vs.analytics.v1.model.entity.WorkItemLink;

@JsonIgnoreType
public class WorkItemLinkRequest extends EntityRequest<WorkItemLink> {

    public WorkItemLinkRequest(ContextPath contextPath, Optional<Object> value) {
        super(WorkItemLink.class, contextPath, value, false);
    }

    public WorkItemRequest sourceWorkItem() {
        return new WorkItemRequest(contextPath.addSegment("SourceWorkItem"), Optional.empty());
    }

    public WorkItemRequest targetWorkItem() {
        return new WorkItemRequest(contextPath.addSegment("TargetWorkItem"), Optional.empty());
    }

    public ProjectRequest project() {
        return new ProjectRequest(contextPath.addSegment("Project"), Optional.empty());
    }

}
