package microsoft.vs.analytics.v1.model.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.vs.analytics.v1.model.entity.Team;
import microsoft.vs.analytics.v1.model.entity.request.AreaRequest;
import microsoft.vs.analytics.v1.model.entity.request.IterationRequest;
import microsoft.vs.analytics.v1.model.entity.request.TeamRequest;

public class TeamCollectionRequest extends CollectionPageEntityRequest<Team, TeamRequest>{

    protected ContextPath contextPath;

    public TeamCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Team.class, cp -> new TeamRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public AreaCollectionRequest areas() {
        return new AreaCollectionRequest(contextPath.addSegment("Areas"), Optional.empty());
    }

    public AreaRequest areas(String areaSK) {
        return new AreaRequest(contextPath.addSegment("Areas").addKeys(new NameValue(areaSK.toString())), Optional.empty());
    }

    public IterationCollectionRequest iterations() {
        return new IterationCollectionRequest(contextPath.addSegment("Iterations"), Optional.empty());
    }

    public IterationRequest iterations(String iterationSK) {
        return new IterationRequest(contextPath.addSegment("Iterations").addKeys(new NameValue(iterationSK.toString())), Optional.empty());
    }

}
