package microsoft.vs.analytics.v1.model.entity;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import microsoft.vs.analytics.v1.model.entity.request.ProjectRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "ProjectSK", 
    "FieldName", 
    "FieldReferenceName", 
    "FieldType", 
    "WorkItemType"})
@JsonInclude(Include.NON_NULL)
public class WorkItemTypeField implements ODataEntityType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JacksonInject
    @JsonIgnore
    protected ChangedFields changedFields;

    @Override
    public String odataTypeName() {
        return "Microsoft.VisualStudio.Services.Analytics.Model.WorkItemTypeField";
    }

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("ProjectSK")
    protected String projectSK;

    @JsonProperty("FieldName")
    protected String fieldName;

    @JsonProperty("FieldReferenceName")
    protected String fieldReferenceName;

    @JsonProperty("FieldType")
    protected String fieldType;

    @JsonProperty("WorkItemType")
    protected String workItemType;

    protected WorkItemTypeField() {
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String projectSK;
        private String fieldName;
        private String fieldReferenceName;
        private String fieldType;
        private String workItemType;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder projectSK(String projectSK) {
            this.projectSK = projectSK;
            this.changedFields = changedFields.add("ProjectSK");
            return this;
        }

        public Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            this.changedFields = changedFields.add("FieldName");
            return this;
        }

        public Builder fieldReferenceName(String fieldReferenceName) {
            this.fieldReferenceName = fieldReferenceName;
            this.changedFields = changedFields.add("FieldReferenceName");
            return this;
        }

        public Builder fieldType(String fieldType) {
            this.fieldType = fieldType;
            this.changedFields = changedFields.add("FieldType");
            return this;
        }

        public Builder workItemType(String workItemType) {
            this.workItemType = workItemType;
            this.changedFields = changedFields.add("WorkItemType");
            return this;
        }

        public WorkItemTypeField build() {
            WorkItemTypeField _x = new WorkItemTypeField();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.VisualStudio.Services.Analytics.Model.WorkItemTypeField";
            _x.projectSK = projectSK;
            _x.fieldName = fieldName;
            _x.fieldReferenceName = fieldReferenceName;
            _x.fieldType = fieldType;
            _x.workItemType = workItemType;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && fieldName != null && projectSK != null && workItemType != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue("FieldName", fieldName), new NameValue("ProjectSK", projectSK), new NameValue("WorkItemType", workItemType));
        }
    }

    @Property(name="ProjectSK")
    @JsonIgnore
    public Optional<String> getProjectSK() {
        return Optional.ofNullable(projectSK);
    }

    public WorkItemTypeField withProjectSK(String projectSK) {
        WorkItemTypeField _x = _copy();
        _x.changedFields = changedFields.add("ProjectSK");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.WorkItemTypeField");
        _x.projectSK = projectSK;
        return _x;
    }

    @Property(name="FieldName")
    @JsonIgnore
    public Optional<String> getFieldName() {
        return Optional.ofNullable(fieldName);
    }

    public WorkItemTypeField withFieldName(String fieldName) {
        WorkItemTypeField _x = _copy();
        _x.changedFields = changedFields.add("FieldName");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.WorkItemTypeField");
        _x.fieldName = fieldName;
        return _x;
    }

    @Property(name="FieldReferenceName")
    @JsonIgnore
    public Optional<String> getFieldReferenceName() {
        return Optional.ofNullable(fieldReferenceName);
    }

    public WorkItemTypeField withFieldReferenceName(String fieldReferenceName) {
        WorkItemTypeField _x = _copy();
        _x.changedFields = changedFields.add("FieldReferenceName");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.WorkItemTypeField");
        _x.fieldReferenceName = fieldReferenceName;
        return _x;
    }

    @Property(name="FieldType")
    @JsonIgnore
    public Optional<String> getFieldType() {
        return Optional.ofNullable(fieldType);
    }

    public WorkItemTypeField withFieldType(String fieldType) {
        WorkItemTypeField _x = _copy();
        _x.changedFields = changedFields.add("FieldType");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.WorkItemTypeField");
        _x.fieldType = fieldType;
        return _x;
    }

    @Property(name="WorkItemType")
    @JsonIgnore
    public Optional<String> getWorkItemType() {
        return Optional.ofNullable(workItemType);
    }

    public WorkItemTypeField withWorkItemType(String workItemType) {
        WorkItemTypeField _x = _copy();
        _x.changedFields = changedFields.add("WorkItemType");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.WorkItemTypeField");
        _x.workItemType = workItemType;
        return _x;
    }

    public WorkItemTypeField withUnmappedField(String name, String value) {
        WorkItemTypeField _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="Project")
    @JsonIgnore
    public ProjectRequest getProject() {
        return new ProjectRequest(contextPath.addSegment("Project"), RequestHelper.getValue(unmappedFields, "Project"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WorkItemTypeField patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        WorkItemTypeField _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public WorkItemTypeField put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        WorkItemTypeField _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private WorkItemTypeField _copy() {
        WorkItemTypeField _x = new WorkItemTypeField();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.projectSK = projectSK;
        _x.fieldName = fieldName;
        _x.fieldReferenceName = fieldReferenceName;
        _x.fieldType = fieldType;
        _x.workItemType = workItemType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WorkItemTypeField[");
        b.append("ProjectSK=");
        b.append(this.projectSK);
        b.append(", ");
        b.append("FieldName=");
        b.append(this.fieldName);
        b.append(", ");
        b.append("FieldReferenceName=");
        b.append(this.fieldReferenceName);
        b.append(", ");
        b.append("FieldType=");
        b.append(this.fieldType);
        b.append(", ");
        b.append("WorkItemType=");
        b.append(this.workItemType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
