package microsoft.vs.analytics.v1.model.entity;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import microsoft.vs.analytics.v1.model.entity.request.ProjectRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "TagSK", 
    "ProjectSK", 
    "TagId", 
    "TagName"})
@JsonInclude(Include.NON_NULL)
public class Tag implements ODataEntityType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JacksonInject
    @JsonIgnore
    protected ChangedFields changedFields;

    @Override
    public String odataTypeName() {
        return "Microsoft.VisualStudio.Services.Analytics.Model.Tag";
    }

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("TagSK")
    protected Integer tagSK;

    @JsonProperty("ProjectSK")
    protected String projectSK;

    @JsonProperty("TagId")
    protected String tagId;

    @JsonProperty("TagName")
    protected String tagName;

    protected Tag() {
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer tagSK;
        private String projectSK;
        private String tagId;
        private String tagName;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder tagSK(Integer tagSK) {
            this.tagSK = tagSK;
            this.changedFields = changedFields.add("TagSK");
            return this;
        }

        public Builder projectSK(String projectSK) {
            this.projectSK = projectSK;
            this.changedFields = changedFields.add("ProjectSK");
            return this;
        }

        public Builder tagId(String tagId) {
            this.tagId = tagId;
            this.changedFields = changedFields.add("TagId");
            return this;
        }

        public Builder tagName(String tagName) {
            this.tagName = tagName;
            this.changedFields = changedFields.add("TagName");
            return this;
        }

        public Tag build() {
            Tag _x = new Tag();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.VisualStudio.Services.Analytics.Model.Tag";
            _x.tagSK = tagSK;
            _x.projectSK = projectSK;
            _x.tagId = tagId;
            _x.tagName = tagName;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && tagSK != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(tagSK.toString()));
        }
    }

    @Property(name="TagSK")
    @JsonIgnore
    public Optional<Integer> getTagSK() {
        return Optional.ofNullable(tagSK);
    }

    public Tag withTagSK(Integer tagSK) {
        Tag _x = _copy();
        _x.changedFields = changedFields.add("TagSK");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.Tag");
        _x.tagSK = tagSK;
        return _x;
    }

    @Property(name="ProjectSK")
    @JsonIgnore
    public Optional<String> getProjectSK() {
        return Optional.ofNullable(projectSK);
    }

    public Tag withProjectSK(String projectSK) {
        Tag _x = _copy();
        _x.changedFields = changedFields.add("ProjectSK");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.Tag");
        _x.projectSK = projectSK;
        return _x;
    }

    @Property(name="TagId")
    @JsonIgnore
    public Optional<String> getTagId() {
        return Optional.ofNullable(tagId);
    }

    public Tag withTagId(String tagId) {
        Tag _x = _copy();
        _x.changedFields = changedFields.add("TagId");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.Tag");
        _x.tagId = tagId;
        return _x;
    }

    @Property(name="TagName")
    @JsonIgnore
    public Optional<String> getTagName() {
        return Optional.ofNullable(tagName);
    }

    public Tag withTagName(String tagName) {
        Tag _x = _copy();
        _x.changedFields = changedFields.add("TagName");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.Tag");
        _x.tagName = tagName;
        return _x;
    }

    public Tag withUnmappedField(String name, String value) {
        Tag _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="Project")
    @JsonIgnore
    public ProjectRequest getProject() {
        return new ProjectRequest(contextPath.addSegment("Project"), RequestHelper.getValue(unmappedFields, "Project"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Tag patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Tag _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Tag put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Tag _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Tag _copy() {
        Tag _x = new Tag();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.tagSK = tagSK;
        _x.projectSK = projectSK;
        _x.tagId = tagId;
        _x.tagName = tagName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Tag[");
        b.append("TagSK=");
        b.append(this.tagSK);
        b.append(", ");
        b.append("ProjectSK=");
        b.append(this.projectSK);
        b.append(", ");
        b.append("TagId=");
        b.append(this.tagId);
        b.append(", ");
        b.append("TagName=");
        b.append(this.tagName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
