package microsoft.vs.analytics.v1.model.entity;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.vs.analytics.v1.model.entity.request.TeamRequest;
import microsoft.vs.analytics.v1.model.enums.BoardColumnSplit;

@JsonPropertyOrder({
    "@odata.type", 
    "ProjectSK", 
    "BoardLocationSK", 
    "ColumnId", 
    "ColumnName", 
    "ColumnOrder", 
    "ColumnItemLimit", 
    "IsDone", 
    "BoardId", 
    "BoardCategoryReferenceName", 
    "BoardName", 
    "BoardLevel", 
    "BacklogType", 
    "IsBoardVisible", 
    "LaneId", 
    "LaneName", 
    "LaneOrder", 
    "IsColumnSplit", 
    "ChangedDate", 
    "RevisedDate", 
    "IsCurrent", 
    "Done", 
    "TeamSK", 
    "IsDefaultLane"})
@JsonInclude(Include.NON_NULL)
public class BoardLocation implements ODataEntityType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JacksonInject
    @JsonIgnore
    protected ChangedFields changedFields;

    @Override
    public String odataTypeName() {
        return "Microsoft.VisualStudio.Services.Analytics.Model.BoardLocation";
    }

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("ProjectSK")
    protected String projectSK;

    @JsonProperty("BoardLocationSK")
    protected Integer boardLocationSK;

    @JsonProperty("ColumnId")
    protected String columnId;

    @JsonProperty("ColumnName")
    protected String columnName;

    @JsonProperty("ColumnOrder")
    protected Integer columnOrder;

    @JsonProperty("ColumnItemLimit")
    protected Integer columnItemLimit;

    @JsonProperty("IsDone")
    protected Boolean isDone;

    @JsonProperty("BoardId")
    protected String boardId;

    @JsonProperty("BoardCategoryReferenceName")
    protected String boardCategoryReferenceName;

    @JsonProperty("BoardName")
    protected String boardName;

    @JsonProperty("BoardLevel")
    protected Integer boardLevel;

    @JsonProperty("BacklogType")
    protected String backlogType;

    @JsonProperty("IsBoardVisible")
    protected Boolean isBoardVisible;

    @JsonProperty("LaneId")
    protected String laneId;

    @JsonProperty("LaneName")
    protected String laneName;

    @JsonProperty("LaneOrder")
    protected Integer laneOrder;

    @JsonProperty("IsColumnSplit")
    protected Boolean isColumnSplit;

    @JsonProperty("ChangedDate")
    protected OffsetDateTime changedDate;

    @JsonProperty("RevisedDate")
    protected OffsetDateTime revisedDate;

    @JsonProperty("IsCurrent")
    protected Boolean isCurrent;

    @JsonProperty("Done")
    protected BoardColumnSplit done;

    @JsonProperty("TeamSK")
    protected String teamSK;

    @JsonProperty("IsDefaultLane")
    protected Boolean isDefaultLane;

    protected BoardLocation() {
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String projectSK;
        private Integer boardLocationSK;
        private String columnId;
        private String columnName;
        private Integer columnOrder;
        private Integer columnItemLimit;
        private Boolean isDone;
        private String boardId;
        private String boardCategoryReferenceName;
        private String boardName;
        private Integer boardLevel;
        private String backlogType;
        private Boolean isBoardVisible;
        private String laneId;
        private String laneName;
        private Integer laneOrder;
        private Boolean isColumnSplit;
        private OffsetDateTime changedDate;
        private OffsetDateTime revisedDate;
        private Boolean isCurrent;
        private BoardColumnSplit done;
        private String teamSK;
        private Boolean isDefaultLane;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder projectSK(String projectSK) {
            this.projectSK = projectSK;
            this.changedFields = changedFields.add("ProjectSK");
            return this;
        }

        public Builder boardLocationSK(Integer boardLocationSK) {
            this.boardLocationSK = boardLocationSK;
            this.changedFields = changedFields.add("BoardLocationSK");
            return this;
        }

        public Builder columnId(String columnId) {
            this.columnId = columnId;
            this.changedFields = changedFields.add("ColumnId");
            return this;
        }

        public Builder columnName(String columnName) {
            this.columnName = columnName;
            this.changedFields = changedFields.add("ColumnName");
            return this;
        }

        public Builder columnOrder(Integer columnOrder) {
            this.columnOrder = columnOrder;
            this.changedFields = changedFields.add("ColumnOrder");
            return this;
        }

        public Builder columnItemLimit(Integer columnItemLimit) {
            this.columnItemLimit = columnItemLimit;
            this.changedFields = changedFields.add("ColumnItemLimit");
            return this;
        }

        public Builder isDone(Boolean isDone) {
            this.isDone = isDone;
            this.changedFields = changedFields.add("IsDone");
            return this;
        }

        public Builder boardId(String boardId) {
            this.boardId = boardId;
            this.changedFields = changedFields.add("BoardId");
            return this;
        }

        public Builder boardCategoryReferenceName(String boardCategoryReferenceName) {
            this.boardCategoryReferenceName = boardCategoryReferenceName;
            this.changedFields = changedFields.add("BoardCategoryReferenceName");
            return this;
        }

        public Builder boardName(String boardName) {
            this.boardName = boardName;
            this.changedFields = changedFields.add("BoardName");
            return this;
        }

        public Builder boardLevel(Integer boardLevel) {
            this.boardLevel = boardLevel;
            this.changedFields = changedFields.add("BoardLevel");
            return this;
        }

        public Builder backlogType(String backlogType) {
            this.backlogType = backlogType;
            this.changedFields = changedFields.add("BacklogType");
            return this;
        }

        public Builder isBoardVisible(Boolean isBoardVisible) {
            this.isBoardVisible = isBoardVisible;
            this.changedFields = changedFields.add("IsBoardVisible");
            return this;
        }

        public Builder laneId(String laneId) {
            this.laneId = laneId;
            this.changedFields = changedFields.add("LaneId");
            return this;
        }

        public Builder laneName(String laneName) {
            this.laneName = laneName;
            this.changedFields = changedFields.add("LaneName");
            return this;
        }

        public Builder laneOrder(Integer laneOrder) {
            this.laneOrder = laneOrder;
            this.changedFields = changedFields.add("LaneOrder");
            return this;
        }

        public Builder isColumnSplit(Boolean isColumnSplit) {
            this.isColumnSplit = isColumnSplit;
            this.changedFields = changedFields.add("IsColumnSplit");
            return this;
        }

        public Builder changedDate(OffsetDateTime changedDate) {
            this.changedDate = changedDate;
            this.changedFields = changedFields.add("ChangedDate");
            return this;
        }

        public Builder revisedDate(OffsetDateTime revisedDate) {
            this.revisedDate = revisedDate;
            this.changedFields = changedFields.add("RevisedDate");
            return this;
        }

        public Builder isCurrent(Boolean isCurrent) {
            this.isCurrent = isCurrent;
            this.changedFields = changedFields.add("IsCurrent");
            return this;
        }

        public Builder done(BoardColumnSplit done) {
            this.done = done;
            this.changedFields = changedFields.add("Done");
            return this;
        }

        public Builder teamSK(String teamSK) {
            this.teamSK = teamSK;
            this.changedFields = changedFields.add("TeamSK");
            return this;
        }

        public Builder isDefaultLane(Boolean isDefaultLane) {
            this.isDefaultLane = isDefaultLane;
            this.changedFields = changedFields.add("IsDefaultLane");
            return this;
        }

        public BoardLocation build() {
            BoardLocation _x = new BoardLocation();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.VisualStudio.Services.Analytics.Model.BoardLocation";
            _x.projectSK = projectSK;
            _x.boardLocationSK = boardLocationSK;
            _x.columnId = columnId;
            _x.columnName = columnName;
            _x.columnOrder = columnOrder;
            _x.columnItemLimit = columnItemLimit;
            _x.isDone = isDone;
            _x.boardId = boardId;
            _x.boardCategoryReferenceName = boardCategoryReferenceName;
            _x.boardName = boardName;
            _x.boardLevel = boardLevel;
            _x.backlogType = backlogType;
            _x.isBoardVisible = isBoardVisible;
            _x.laneId = laneId;
            _x.laneName = laneName;
            _x.laneOrder = laneOrder;
            _x.isColumnSplit = isColumnSplit;
            _x.changedDate = changedDate;
            _x.revisedDate = revisedDate;
            _x.isCurrent = isCurrent;
            _x.done = done;
            _x.teamSK = teamSK;
            _x.isDefaultLane = isDefaultLane;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && boardLocationSK != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(boardLocationSK.toString()));
        }
    }

    @Property(name="ProjectSK")
    @JsonIgnore
    public Optional<String> getProjectSK() {
        return Optional.ofNullable(projectSK);
    }

    public BoardLocation withProjectSK(String projectSK) {
        BoardLocation _x = _copy();
        _x.changedFields = changedFields.add("ProjectSK");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.BoardLocation");
        _x.projectSK = projectSK;
        return _x;
    }

    @Property(name="BoardLocationSK")
    @JsonIgnore
    public Optional<Integer> getBoardLocationSK() {
        return Optional.ofNullable(boardLocationSK);
    }

    public BoardLocation withBoardLocationSK(Integer boardLocationSK) {
        BoardLocation _x = _copy();
        _x.changedFields = changedFields.add("BoardLocationSK");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.BoardLocation");
        _x.boardLocationSK = boardLocationSK;
        return _x;
    }

    @Property(name="ColumnId")
    @JsonIgnore
    public Optional<String> getColumnId() {
        return Optional.ofNullable(columnId);
    }

    public BoardLocation withColumnId(String columnId) {
        BoardLocation _x = _copy();
        _x.changedFields = changedFields.add("ColumnId");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.BoardLocation");
        _x.columnId = columnId;
        return _x;
    }

    @Property(name="ColumnName")
    @JsonIgnore
    public Optional<String> getColumnName() {
        return Optional.ofNullable(columnName);
    }

    public BoardLocation withColumnName(String columnName) {
        BoardLocation _x = _copy();
        _x.changedFields = changedFields.add("ColumnName");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.BoardLocation");
        _x.columnName = columnName;
        return _x;
    }

    @Property(name="ColumnOrder")
    @JsonIgnore
    public Optional<Integer> getColumnOrder() {
        return Optional.ofNullable(columnOrder);
    }

    public BoardLocation withColumnOrder(Integer columnOrder) {
        BoardLocation _x = _copy();
        _x.changedFields = changedFields.add("ColumnOrder");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.BoardLocation");
        _x.columnOrder = columnOrder;
        return _x;
    }

    @Property(name="ColumnItemLimit")
    @JsonIgnore
    public Optional<Integer> getColumnItemLimit() {
        return Optional.ofNullable(columnItemLimit);
    }

    public BoardLocation withColumnItemLimit(Integer columnItemLimit) {
        BoardLocation _x = _copy();
        _x.changedFields = changedFields.add("ColumnItemLimit");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.BoardLocation");
        _x.columnItemLimit = columnItemLimit;
        return _x;
    }

    @Property(name="IsDone")
    @JsonIgnore
    public Optional<Boolean> getIsDone() {
        return Optional.ofNullable(isDone);
    }

    public BoardLocation withIsDone(Boolean isDone) {
        BoardLocation _x = _copy();
        _x.changedFields = changedFields.add("IsDone");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.BoardLocation");
        _x.isDone = isDone;
        return _x;
    }

    @Property(name="BoardId")
    @JsonIgnore
    public Optional<String> getBoardId() {
        return Optional.ofNullable(boardId);
    }

    public BoardLocation withBoardId(String boardId) {
        BoardLocation _x = _copy();
        _x.changedFields = changedFields.add("BoardId");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.BoardLocation");
        _x.boardId = boardId;
        return _x;
    }

    @Property(name="BoardCategoryReferenceName")
    @JsonIgnore
    public Optional<String> getBoardCategoryReferenceName() {
        return Optional.ofNullable(boardCategoryReferenceName);
    }

    public BoardLocation withBoardCategoryReferenceName(String boardCategoryReferenceName) {
        BoardLocation _x = _copy();
        _x.changedFields = changedFields.add("BoardCategoryReferenceName");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.BoardLocation");
        _x.boardCategoryReferenceName = boardCategoryReferenceName;
        return _x;
    }

    @Property(name="BoardName")
    @JsonIgnore
    public Optional<String> getBoardName() {
        return Optional.ofNullable(boardName);
    }

    public BoardLocation withBoardName(String boardName) {
        BoardLocation _x = _copy();
        _x.changedFields = changedFields.add("BoardName");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.BoardLocation");
        _x.boardName = boardName;
        return _x;
    }

    @Property(name="BoardLevel")
    @JsonIgnore
    public Optional<Integer> getBoardLevel() {
        return Optional.ofNullable(boardLevel);
    }

    public BoardLocation withBoardLevel(Integer boardLevel) {
        BoardLocation _x = _copy();
        _x.changedFields = changedFields.add("BoardLevel");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.BoardLocation");
        _x.boardLevel = boardLevel;
        return _x;
    }

    @Property(name="BacklogType")
    @JsonIgnore
    public Optional<String> getBacklogType() {
        return Optional.ofNullable(backlogType);
    }

    public BoardLocation withBacklogType(String backlogType) {
        BoardLocation _x = _copy();
        _x.changedFields = changedFields.add("BacklogType");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.BoardLocation");
        _x.backlogType = backlogType;
        return _x;
    }

    @Property(name="IsBoardVisible")
    @JsonIgnore
    public Optional<Boolean> getIsBoardVisible() {
        return Optional.ofNullable(isBoardVisible);
    }

    public BoardLocation withIsBoardVisible(Boolean isBoardVisible) {
        BoardLocation _x = _copy();
        _x.changedFields = changedFields.add("IsBoardVisible");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.BoardLocation");
        _x.isBoardVisible = isBoardVisible;
        return _x;
    }

    @Property(name="LaneId")
    @JsonIgnore
    public Optional<String> getLaneId() {
        return Optional.ofNullable(laneId);
    }

    public BoardLocation withLaneId(String laneId) {
        BoardLocation _x = _copy();
        _x.changedFields = changedFields.add("LaneId");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.BoardLocation");
        _x.laneId = laneId;
        return _x;
    }

    @Property(name="LaneName")
    @JsonIgnore
    public Optional<String> getLaneName() {
        return Optional.ofNullable(laneName);
    }

    public BoardLocation withLaneName(String laneName) {
        BoardLocation _x = _copy();
        _x.changedFields = changedFields.add("LaneName");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.BoardLocation");
        _x.laneName = laneName;
        return _x;
    }

    @Property(name="LaneOrder")
    @JsonIgnore
    public Optional<Integer> getLaneOrder() {
        return Optional.ofNullable(laneOrder);
    }

    public BoardLocation withLaneOrder(Integer laneOrder) {
        BoardLocation _x = _copy();
        _x.changedFields = changedFields.add("LaneOrder");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.BoardLocation");
        _x.laneOrder = laneOrder;
        return _x;
    }

    @Property(name="IsColumnSplit")
    @JsonIgnore
    public Optional<Boolean> getIsColumnSplit() {
        return Optional.ofNullable(isColumnSplit);
    }

    public BoardLocation withIsColumnSplit(Boolean isColumnSplit) {
        BoardLocation _x = _copy();
        _x.changedFields = changedFields.add("IsColumnSplit");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.BoardLocation");
        _x.isColumnSplit = isColumnSplit;
        return _x;
    }

    @Property(name="ChangedDate")
    @JsonIgnore
    public Optional<OffsetDateTime> getChangedDate() {
        return Optional.ofNullable(changedDate);
    }

    public BoardLocation withChangedDate(OffsetDateTime changedDate) {
        BoardLocation _x = _copy();
        _x.changedFields = changedFields.add("ChangedDate");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.BoardLocation");
        _x.changedDate = changedDate;
        return _x;
    }

    @Property(name="RevisedDate")
    @JsonIgnore
    public Optional<OffsetDateTime> getRevisedDate() {
        return Optional.ofNullable(revisedDate);
    }

    public BoardLocation withRevisedDate(OffsetDateTime revisedDate) {
        BoardLocation _x = _copy();
        _x.changedFields = changedFields.add("RevisedDate");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.BoardLocation");
        _x.revisedDate = revisedDate;
        return _x;
    }

    @Property(name="IsCurrent")
    @JsonIgnore
    public Optional<Boolean> getIsCurrent() {
        return Optional.ofNullable(isCurrent);
    }

    public BoardLocation withIsCurrent(Boolean isCurrent) {
        BoardLocation _x = _copy();
        _x.changedFields = changedFields.add("IsCurrent");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.BoardLocation");
        _x.isCurrent = isCurrent;
        return _x;
    }

    @Property(name="Done")
    @JsonIgnore
    public Optional<BoardColumnSplit> getDone() {
        return Optional.ofNullable(done);
    }

    public BoardLocation withDone(BoardColumnSplit done) {
        BoardLocation _x = _copy();
        _x.changedFields = changedFields.add("Done");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.BoardLocation");
        _x.done = done;
        return _x;
    }

    @Property(name="TeamSK")
    @JsonIgnore
    public Optional<String> getTeamSK() {
        return Optional.ofNullable(teamSK);
    }

    public BoardLocation withTeamSK(String teamSK) {
        BoardLocation _x = _copy();
        _x.changedFields = changedFields.add("TeamSK");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.BoardLocation");
        _x.teamSK = teamSK;
        return _x;
    }

    @Property(name="IsDefaultLane")
    @JsonIgnore
    public Optional<Boolean> getIsDefaultLane() {
        return Optional.ofNullable(isDefaultLane);
    }

    public BoardLocation withIsDefaultLane(Boolean isDefaultLane) {
        BoardLocation _x = _copy();
        _x.changedFields = changedFields.add("IsDefaultLane");
        _x.odataType = Util.nvl(odataType, "Microsoft.VisualStudio.Services.Analytics.Model.BoardLocation");
        _x.isDefaultLane = isDefaultLane;
        return _x;
    }

    public BoardLocation withUnmappedField(String name, String value) {
        BoardLocation _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="Team")
    @JsonIgnore
    public TeamRequest getTeam() {
        return new TeamRequest(contextPath.addSegment("Team"), RequestHelper.getValue(unmappedFields, "Team"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public BoardLocation patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        BoardLocation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public BoardLocation put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        BoardLocation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private BoardLocation _copy() {
        BoardLocation _x = new BoardLocation();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.projectSK = projectSK;
        _x.boardLocationSK = boardLocationSK;
        _x.columnId = columnId;
        _x.columnName = columnName;
        _x.columnOrder = columnOrder;
        _x.columnItemLimit = columnItemLimit;
        _x.isDone = isDone;
        _x.boardId = boardId;
        _x.boardCategoryReferenceName = boardCategoryReferenceName;
        _x.boardName = boardName;
        _x.boardLevel = boardLevel;
        _x.backlogType = backlogType;
        _x.isBoardVisible = isBoardVisible;
        _x.laneId = laneId;
        _x.laneName = laneName;
        _x.laneOrder = laneOrder;
        _x.isColumnSplit = isColumnSplit;
        _x.changedDate = changedDate;
        _x.revisedDate = revisedDate;
        _x.isCurrent = isCurrent;
        _x.done = done;
        _x.teamSK = teamSK;
        _x.isDefaultLane = isDefaultLane;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("BoardLocation[");
        b.append("ProjectSK=");
        b.append(this.projectSK);
        b.append(", ");
        b.append("BoardLocationSK=");
        b.append(this.boardLocationSK);
        b.append(", ");
        b.append("ColumnId=");
        b.append(this.columnId);
        b.append(", ");
        b.append("ColumnName=");
        b.append(this.columnName);
        b.append(", ");
        b.append("ColumnOrder=");
        b.append(this.columnOrder);
        b.append(", ");
        b.append("ColumnItemLimit=");
        b.append(this.columnItemLimit);
        b.append(", ");
        b.append("IsDone=");
        b.append(this.isDone);
        b.append(", ");
        b.append("BoardId=");
        b.append(this.boardId);
        b.append(", ");
        b.append("BoardCategoryReferenceName=");
        b.append(this.boardCategoryReferenceName);
        b.append(", ");
        b.append("BoardName=");
        b.append(this.boardName);
        b.append(", ");
        b.append("BoardLevel=");
        b.append(this.boardLevel);
        b.append(", ");
        b.append("BacklogType=");
        b.append(this.backlogType);
        b.append(", ");
        b.append("IsBoardVisible=");
        b.append(this.isBoardVisible);
        b.append(", ");
        b.append("LaneId=");
        b.append(this.laneId);
        b.append(", ");
        b.append("LaneName=");
        b.append(this.laneName);
        b.append(", ");
        b.append("LaneOrder=");
        b.append(this.laneOrder);
        b.append(", ");
        b.append("IsColumnSplit=");
        b.append(this.isColumnSplit);
        b.append(", ");
        b.append("ChangedDate=");
        b.append(this.changedDate);
        b.append(", ");
        b.append("RevisedDate=");
        b.append(this.revisedDate);
        b.append(", ");
        b.append("IsCurrent=");
        b.append(this.isCurrent);
        b.append(", ");
        b.append("Done=");
        b.append(this.done);
        b.append(", ");
        b.append("TeamSK=");
        b.append(this.teamSK);
        b.append(", ");
        b.append("IsDefaultLane=");
        b.append(this.isDefaultLane);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
