/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.kool.internal.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.davidmoten.kool.Maybe;
import org.davidmoten.kool.StreamIterable;

public final class Iterables {
    private Iterables() {
    }

    public static <T> Iterable<T> fromArray(final T[] array) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    int i = 0;

                    @Override
                    public boolean hasNext() {
                        return this.i < array.length;
                    }

                    @Override
                    public T next() {
                        ++this.i;
                        if (this.i > array.length) {
                            throw new NoSuchElementException();
                        }
                        return array[this.i - 1];
                    }
                };
            }
        };
    }

    @SafeVarargs
    public static <T> Iterable<T> ofNoCopy(final T ... values) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    int i = 0;

                    @Override
                    public boolean hasNext() {
                        return this.i < values.length;
                    }

                    @Override
                    public T next() {
                        if (this.i >= values.length) {
                            throw new NoSuchElementException();
                        }
                        Object t = values[this.i];
                        ++this.i;
                        return t;
                    }
                };
            }
        };
    }

    public static <T> Maybe<T> first(Iterator<T> it) {
        if (it.hasNext()) {
            return Maybe.of(it.next());
        }
        return Maybe.empty();
    }

    public static <R extends Collection<S>, S, T extends S> R addAll(R collection, StreamIterable<T> iterable) {
        Iterator it = iterable.iterator();
        try {
            while (it.hasNext()) {
                collection.add(it.next());
            }
        }
        finally {
            it.dispose();
        }
        return collection;
    }
}

