/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.kool.internal.util;

import java.util.NoSuchElementException;
import org.davidmoten.kool.StreamIterable;
import org.davidmoten.kool.StreamIterator;

public abstract class BaseStreamIterator<R, T>
implements StreamIterator<T> {
    protected T next;
    protected StreamIterator<R> it;

    public BaseStreamIterator(StreamIterable<R> stream) {
        this.it = this.init(stream);
    }

    public StreamIterator<R> init(StreamIterable<R> stream) {
        return stream.iteratorChecked();
    }

    @Override
    public final boolean hasNext() {
        boolean result;
        this.loadNext();
        boolean bl = result = this.next != null;
        if (!result) {
            this.dispose();
        }
        return result;
    }

    @Override
    public final T next() {
        this.loadNext();
        T v = this.next;
        if (v != null) {
            this.next = null;
            return v;
        }
        throw new NoSuchElementException();
    }

    private void loadNext() {
        if (this.it != null && this.next == null) {
            this.load();
        }
    }

    @Override
    public void dispose() {
        if (this.it != null) {
            this.it.dispose();
            this.it = null;
            this.next = null;
        }
    }

    public abstract void load();
}

