/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.kool.internal.operators.stream;

import org.davidmoten.kool.Stream;
import org.davidmoten.kool.StreamIterator;
import org.davidmoten.kool.function.BiFunction;

public class Zip<R, S, T>
implements Stream<S> {
    private final Stream<T> source1;
    private final Stream<? extends R> source2;
    private final BiFunction<T, R, S> combiner;

    public Zip(Stream<T> source1, Stream<? extends R> source2, BiFunction<T, R, S> combiner) {
        this.source1 = source1;
        this.source2 = source2;
        this.combiner = combiner;
    }

    @Override
    public StreamIterator<S> iterator() {
        return new StreamIterator<S>(){
            StreamIterator<T> a;
            StreamIterator<? extends R> b;
            {
                this.a = Zip.this.source1.iteratorChecked();
                this.b = Zip.this.source2.iteratorChecked();
            }

            @Override
            public boolean hasNext() {
                boolean hasA = this.a.hasNext();
                boolean hasB = this.b.hasNext();
                if (hasA && hasB || !hasA && !hasB) {
                    return hasA;
                }
                this.a.dispose();
                this.b.dispose();
                throw new RuntimeException("streams must have same length to be zipped");
            }

            @Override
            public S next() {
                return Zip.this.combiner.applyUnchecked(this.a.nextChecked(), this.b.nextChecked());
            }

            @Override
            public void dispose() {
                this.a.dispose();
                this.b.dispose();
            }
        };
    }
}

