/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.kool.internal.operators.stream;

import java.util.concurrent.Callable;
import org.davidmoten.kool.Stream;
import org.davidmoten.kool.StreamIterator;
import org.davidmoten.kool.function.Consumer;
import org.davidmoten.kool.function.Function;
import org.davidmoten.kool.internal.util.Exceptions;

public final class Using<R, T>
implements Stream<T> {
    private final Callable<R> resourceFactory;
    private final Function<? super R, ? extends Stream<? extends T>> streamFactory;
    private final Consumer<? super R> closer;

    public Using(Callable<R> resourceFactory, Function<? super R, ? extends Stream<? extends T>> streamFactory, Consumer<? super R> closer) {
        this.resourceFactory = resourceFactory;
        this.streamFactory = streamFactory;
        this.closer = closer;
    }

    @Override
    public StreamIterator<T> iterator() {
        try {
            return new StreamIterator<T>(){
                R resource;
                StreamIterator<T> it;
                {
                    this.resource = Using.this.resourceFactory.call();
                    this.it = ((Stream)Using.this.streamFactory.apply(this.resource)).iteratorChecked();
                }

                @Override
                public boolean hasNext() {
                    return this.it.hasNext();
                }

                @Override
                public T next() {
                    return this.it.nextChecked();
                }

                @Override
                public void dispose() {
                    this.it.dispose();
                    Using.this.closer.acceptUnchecked(this.resource);
                }
            };
        }
        catch (Throwable e) {
            return (StreamIterator)Exceptions.rethrow(e);
        }
    }
}

