/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.kool.internal.operators.stream;

import org.davidmoten.kool.Stream;
import org.davidmoten.kool.StreamIterator;
import org.davidmoten.kool.function.Predicate;
import org.davidmoten.kool.internal.util.BaseStreamIterator;

public final class TakeWithPredicate<T>
implements Stream<T> {
    private final Predicate<? super T> predicate;
    private final Stream<T> source;
    private final boolean until;

    public TakeWithPredicate(Predicate<? super T> predicate, Stream<T> source, boolean until) {
        this.predicate = predicate;
        this.source = source;
        this.until = until;
    }

    @Override
    public StreamIterator<T> iterator() {
        return new BaseStreamIterator<T, T>(this.source){

            @Override
            public void load() {
                if (this.next == null && this.it != null) {
                    if (this.it.hasNext()) {
                        Object v = this.it.nextChecked();
                        boolean test = TakeWithPredicate.this.predicate.testUnchecked(v);
                        boolean ok = TakeWithPredicate.this.until ? !test : test;
                        if (ok) {
                            this.next = v;
                        } else {
                            this.it.dispose();
                            this.it = null;
                        }
                    } else {
                        this.it.dispose();
                        this.it = null;
                    }
                }
            }
        };
    }
}

