/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.kool.internal.operators.stream;

import org.davidmoten.kool.Stream;
import org.davidmoten.kool.StreamIterator;
import org.davidmoten.kool.internal.util.EvictingQueue;

public final class TakeLast<T>
implements Stream<T> {
    private final Stream<T> stream;
    private final long n;

    public TakeLast(Stream<T> stream, long n) {
        this.stream = stream;
        this.n = n;
    }

    @Override
    public StreamIterator<T> iterator() {
        return new StreamIterator<T>(){
            StreamIterator<T> it;
            EvictingQueue<T> queue;
            {
                this.it = TakeLast.this.stream.iteratorChecked();
                this.queue = new EvictingQueue(TakeLast.this.n);
            }

            @Override
            public boolean hasNext() {
                this.load();
                return this.queue.hasMoreElements();
            }

            @Override
            public T next() {
                this.load();
                return this.queue.nextElement();
            }

            @Override
            public void dispose() {
                if (this.it != null) {
                    this.it.dispose();
                    this.it = null;
                    this.queue = null;
                }
            }

            private void load() {
                if (this.it != null) {
                    while (this.it.hasNext()) {
                        this.queue.add(this.it.nextChecked());
                    }
                    this.it = null;
                }
            }
        };
    }
}

