/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.kool.internal.operators.stream;

import com.github.davidmoten.guavamini.Preconditions;
import org.davidmoten.kool.Stream;
import org.davidmoten.kool.StreamIterable;
import org.davidmoten.kool.StreamIterator;
import org.davidmoten.kool.function.Function;

public final class SwitchOnError<T>
implements Stream<T> {
    private final Function<? super Throwable, ? extends StreamIterable<? extends T>> function;
    private final Stream<T> source;

    public SwitchOnError(Function<? super Throwable, ? extends StreamIterable<? extends T>> function, Stream<T> source) {
        this.function = function;
        this.source = source;
    }

    @Override
    public StreamIterator<T> iterator() {
        return new StreamIterator<T>(){
            StreamIterator<T> it = this.getIterator();
            boolean switched = false;

            private StreamIterator<T> getIterator() {
                try {
                    return SwitchOnError.this.source.iteratorChecked();
                }
                catch (Error | RuntimeException e) {
                    this.switched = true;
                    return (StreamIterator)Preconditions.checkNotNull(((Stream)SwitchOnError.this.function.applyUnchecked(e)).iteratorChecked());
                }
            }

            @Override
            public boolean hasNext() {
                if (this.switched) {
                    return this.it.hasNext();
                }
                try {
                    return this.it.hasNext();
                }
                catch (Throwable e) {
                    this.switched = true;
                    this.it.dispose();
                    this.it = (StreamIterator)Preconditions.checkNotNull(((StreamIterable)SwitchOnError.this.function.applyUnchecked(e)).iteratorChecked());
                    return this.it.hasNext();
                }
            }

            @Override
            public T next() {
                if (this.switched) {
                    return this.it.nextChecked();
                }
                try {
                    return this.it.nextChecked();
                }
                catch (Throwable e) {
                    this.switched = true;
                    this.it.dispose();
                    this.it = (StreamIterator)Preconditions.checkNotNull(((StreamIterable)SwitchOnError.this.function.applyUnchecked(e)).iteratorChecked());
                    return this.it.next();
                }
            }

            @Override
            public void dispose() {
                this.it.dispose();
            }
        };
    }
}

