/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.kool.internal.operators.stream;

import java.util.NoSuchElementException;
import org.davidmoten.kool.Stream;
import org.davidmoten.kool.StreamIterator;

public final class Split
implements Stream<String> {
    private final String delimiter;
    private final Stream<?> source;

    public Split(String delimiter, Stream<?> source) {
        this.delimiter = delimiter;
        this.source = source;
    }

    @Override
    public StreamIterator<String> iterator() {
        return new StreamIterator<String>(){
            StreamIterator<?> it;
            StringBuilder b;
            String next;
            int startFrom;
            {
                this.it = Split.this.source.iteratorChecked();
                this.b = new StringBuilder();
            }

            @Override
            public boolean hasNext() {
                this.loadNext();
                return this.next != null;
            }

            @Override
            public String next() {
                this.loadNext();
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                String t = this.next;
                this.next = null;
                return t;
            }

            @Override
            public void dispose() {
                this.it.dispose();
            }

            private void loadNext() {
                if (this.b != null && this.next == null) {
                    int i;
                    if (this.startFrom <= this.b.length() - Split.this.delimiter.length() && (i = this.b.indexOf(Split.this.delimiter, this.startFrom)) != -1) {
                        this.next = this.b.substring(0, i);
                        this.b.delete(0, i + Split.this.delimiter.length());
                        this.startFrom -= i + Split.this.delimiter.length();
                        return;
                    }
                    while (this.it.hasNext()) {
                        String s = this.it.nextChecked().toString();
                        this.b.append(s);
                        int i2 = this.b.indexOf(Split.this.delimiter, this.startFrom);
                        if (i2 == -1) continue;
                        this.next = this.b.substring(0, i2);
                        this.b.delete(0, i2 + Split.this.delimiter.length());
                        this.startFrom -= i2 + Split.this.delimiter.length();
                        return;
                    }
                    if (this.b.length() > 0) {
                        this.next = this.b.toString();
                    }
                    this.b = null;
                }
            }
        };
    }
}

