/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.kool.internal.operators.stream;

import com.github.davidmoten.guavamini.Preconditions;
import java.util.concurrent.Callable;
import org.davidmoten.kool.Single;
import org.davidmoten.kool.StreamIterable;
import org.davidmoten.kool.StreamIterator;
import org.davidmoten.kool.function.BiFunction;
import org.davidmoten.kool.internal.util.Exceptions;

public final class ReduceWithInitialValueSupplier<R, T>
implements Single<R> {
    private final Callable<R> initialValue;
    private final BiFunction<? super R, ? super T, ? extends R> reducer;
    private final StreamIterable<T> source;

    public ReduceWithInitialValueSupplier(Callable<R> initialValue, BiFunction<? super R, ? super T, ? extends R> reducer, StreamIterable<T> source) {
        this.initialValue = initialValue;
        this.reducer = reducer;
        this.source = source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public R get() {
        StreamIterator<T> it = null;
        try {
            it = this.source.iteratorChecked();
            Object r = Preconditions.checkNotNull(this.initialValue.call());
            while (it.hasNext()) {
                r = Preconditions.checkNotNull(this.reducer.apply(r, it.next()));
            }
            Object object = r;
            return (R)object;
        }
        catch (Exception e) {
            Object t = Exceptions.rethrow(e);
            return (R)t;
        }
        finally {
            if (it != null) {
                it.dispose();
            }
        }
    }
}

