/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.kool.internal.operators.stream;

import com.github.davidmoten.guavamini.Preconditions;
import java.util.Optional;
import org.davidmoten.kool.Maybe;
import org.davidmoten.kool.StreamIterable;
import org.davidmoten.kool.StreamIterator;
import org.davidmoten.kool.function.BiFunction;

public final class ReduceNoInitialValue<T>
implements Maybe<T> {
    private final BiFunction<? super T, ? super T, ? extends T> reducer;
    private final StreamIterable<T> source;

    public ReduceNoInitialValue(BiFunction<? super T, ? super T, ? extends T> reducer, StreamIterable<T> source) {
        this.reducer = reducer;
        this.source = source;
    }

    @Override
    public Optional<T> get() {
        StreamIterator<T> it = this.source.iteratorChecked();
        if (!it.hasNext()) {
            return Optional.empty();
        }
        T a = it.nextChecked();
        if (!it.hasNext()) {
            return Optional.empty();
        }
        T b = it.nextChecked();
        Object v = this.reducer.applyUnchecked(a, b);
        while (it.hasNext()) {
            v = Preconditions.checkNotNull(this.reducer.applyUnchecked(v, it.nextChecked()));
        }
        return Optional.of(v);
    }
}

