/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.kool.internal.operators.stream;

import java.util.Comparator;
import java.util.Optional;
import org.davidmoten.kool.Maybe;
import org.davidmoten.kool.Stream;
import org.davidmoten.kool.StreamIterator;

public class Max<T>
implements Maybe<T> {
    private final Stream<T> stream;
    private final Comparator<? super T> comparator;
    private final boolean not;

    public Max(Stream<T> stream, Comparator<? super T> comparator, boolean not) {
        this.stream = stream;
        this.comparator = comparator;
        this.not = not;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<T> get() {
        StreamIterator it = this.stream.iteratorChecked();
        try {
            Object max = null;
            while (it.hasNext()) {
                Object v = it.nextChecked();
                if (max == null) {
                    max = v;
                    continue;
                }
                boolean comp = this.comparator.compare(max, v) < 0;
                if (!(comp ^ this.not)) continue;
                max = v;
            }
            Optional<Object> optional = Optional.ofNullable(max);
            return optional;
        }
        finally {
            it.dispose();
        }
    }
}

