/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.kool.internal.operators.stream;

import org.davidmoten.kool.Plugins;
import org.davidmoten.kool.Stream;
import org.davidmoten.kool.StreamIterator;
import org.davidmoten.kool.function.Consumer;

public final class IgnoreDisposalError<T>
implements Stream<T> {
    private final Stream<T> stream;
    private final Consumer<? super Throwable> consumer;

    public IgnoreDisposalError(Stream<T> stream, Consumer<? super Throwable> consumer) {
        this.stream = stream;
        this.consumer = consumer;
    }

    @Override
    public StreamIterator<T> iterator() {
        return new StreamIterator<T>(){
            StreamIterator<T> it;
            {
                this.it = IgnoreDisposalError.this.stream.iteratorChecked();
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public T next() {
                return this.it.nextChecked();
            }

            @Override
            public void dispose() {
                if (this.it != null) {
                    try {
                        this.it.dispose();
                    }
                    catch (Throwable e) {
                        if (IgnoreDisposalError.this.consumer != null) {
                            try {
                                IgnoreDisposalError.this.consumer.accept(e);
                            }
                            catch (Throwable e2) {
                                Plugins.onError(e2);
                            }
                        }
                    }
                    finally {
                        this.it = null;
                    }
                }
            }
        };
    }
}

