/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.kool.internal.operators.stream;

import org.davidmoten.kool.Stream;
import org.davidmoten.kool.StreamIterator;
import org.davidmoten.kool.function.Consumer;

public final class DoOnError<T>
implements Stream<T> {
    private Consumer<? super Throwable> consumer;
    private Stream<T> source;

    public DoOnError(Consumer<? super Throwable> consumer, Stream<T> source) {
        this.consumer = consumer;
        this.source = source;
    }

    @Override
    public StreamIterator<T> iterator() {
        return new StreamIterator<T>(){
            StreamIterator<T> it = this.getIterator();

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public T next() {
                try {
                    return this.it.nextChecked();
                }
                catch (Error | RuntimeException t) {
                    DoOnError.this.consumer.acceptUnchecked(t);
                    throw t;
                }
            }

            private StreamIterator<T> getIterator() {
                try {
                    return DoOnError.this.source.iteratorChecked();
                }
                catch (Error | RuntimeException t) {
                    DoOnError.this.consumer.acceptUnchecked(t);
                    throw t;
                }
            }

            @Override
            public void dispose() {
                this.it.dispose();
            }
        };
    }
}

