/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.kool.internal.operators.stream;

import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.guavamini.Sets;
import java.util.Set;
import org.davidmoten.kool.Stream;
import org.davidmoten.kool.StreamIterator;
import org.davidmoten.kool.function.Function;
import org.davidmoten.kool.internal.util.BaseStreamIterator;

public final class Distinct<T, K>
implements Stream<T> {
    private final Stream<T> stream;
    private final Function<? super T, K> keySelector;

    public Distinct(Stream<T> stream, Function<? super T, K> keySelector) {
        Preconditions.checkNotNull(keySelector);
        this.stream = stream;
        this.keySelector = keySelector;
    }

    @Override
    public StreamIterator<T> iterator() {
        return new BaseStreamIterator<T, T>(this.stream){
            Set<K> set;
            {
                this.set = Sets.newHashSet();
            }

            @Override
            public void dispose() {
                super.dispose();
                this.set = null;
            }

            @Override
            public void load() {
                while (this.it.hasNext()) {
                    Object v = this.it.nextChecked();
                    Object k = Preconditions.checkNotNull(Distinct.this.keySelector.applyUnchecked(v));
                    if (this.set.contains(k)) continue;
                    this.set.add(k);
                    this.next = v;
                    return;
                }
            }
        };
    }
}

