/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.kool.internal.operators.stream;

import java.util.NoSuchElementException;
import org.davidmoten.kool.Notification;
import org.davidmoten.kool.Stream;
import org.davidmoten.kool.StreamIterator;
import org.davidmoten.kool.internal.util.BaseStreamIterator;
import org.davidmoten.kool.internal.util.Exceptions;

public final class Dematerialize<T, R>
implements Stream<R> {
    private final Stream<T> stream;

    public Dematerialize(Stream<T> stream) {
        this.stream = stream;
    }

    @Override
    public StreamIterator<R> iterator() {
        return new BaseStreamIterator<T, R>(this.stream){
            boolean empty;
            boolean terminated;
            {
                this.empty = true;
            }

            @Override
            public void load() {
                if (this.it.hasNext()) {
                    this.empty = false;
                    Notification v = (Notification)this.it.next();
                    if (v.hasValue()) {
                        this.next = v.value();
                    } else if (v.isComplete()) {
                        this.dispose();
                        this.terminated = true;
                    } else {
                        Exceptions.rethrow(v.error());
                    }
                } else if (this.empty || !this.terminated) {
                    throw new NoSuchElementException("no notifications found which corresponds to a stream that emits nothing and blocks forever");
                }
            }
        };
    }
}

