/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.kool.internal.operators.stream;

import java.util.concurrent.Callable;
import org.davidmoten.kool.Single;
import org.davidmoten.kool.Stream;
import org.davidmoten.kool.StreamIterator;
import org.davidmoten.kool.function.BiConsumer;
import org.davidmoten.kool.internal.util.Exceptions;

public final class Collect<T, R>
implements Single<R> {
    private final Callable<? extends R> factory;
    private final BiConsumer<? super R, ? super T> collector;
    private final Stream<T> source;

    public Collect(Callable<? extends R> factory, BiConsumer<? super R, ? super T> collector, Stream<T> source) {
        this.factory = factory;
        this.collector = collector;
        this.source = source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public R get() {
        StreamIterator it = this.source.iteratorChecked();
        try {
            R c = this.factory.call();
            while (it.hasNext()) {
                this.collector.accept(c, it.nextChecked());
            }
            R r = c;
            return r;
        }
        catch (Throwable e) {
            Object t = Exceptions.rethrow(e);
            return (R)t;
        }
        finally {
            it.dispose();
        }
    }
}

