/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.kool.internal.operators.stream;

import com.github.davidmoten.guavamini.Lists;
import java.util.List;
import org.davidmoten.kool.Stream;
import org.davidmoten.kool.StreamIterator;

public final class Cache<T>
implements Stream<T> {
    private final Stream<T> stream;
    private final List<T> list = Lists.newArrayList();
    private Stream<T> cache;

    public Cache(Stream<T> stream) {
        this.stream = stream;
    }

    @Override
    public StreamIterator<T> iterator() {
        if (this.cache != null) {
            return this.cache.iterator();
        }
        return new StreamIterator<T>(){
            StreamIterator<T> it;
            {
                this.it = Cache.this.stream.iteratorChecked();
            }

            @Override
            public boolean hasNext() {
                if (this.it == null) {
                    return false;
                }
                boolean hasNext = this.it.hasNext();
                if (!hasNext) {
                    Cache.this.cache = Stream.from(Cache.this.list);
                    this.dispose();
                }
                return hasNext;
            }

            @Override
            public T next() {
                Object v = this.it.nextChecked();
                Cache.this.list.add(v);
                return v;
            }

            @Override
            public void dispose() {
                if (this.it != null) {
                    this.it.dispose();
                    this.it = null;
                }
            }
        };
    }
}

