/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.kool.internal.operators.stream;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.davidmoten.kool.Stream;
import org.davidmoten.kool.StreamIterator;

public class Buffer<T>
implements Stream<List<T>> {
    private final Stream<T> stream;
    private final int size;
    private final int step;

    public Buffer(Stream<T> stream, int size, int step) {
        this.stream = stream;
        this.size = size;
        this.step = step;
    }

    @Override
    public StreamIterator<List<T>> iterator() {
        return new StreamIterator<List<T>>(){
            StreamIterator<T> it;
            List<T> buffer;
            {
                this.it = Buffer.this.stream.iteratorChecked();
                this.buffer = new ArrayList(Buffer.this.size);
            }

            @Override
            public boolean hasNext() {
                this.loadNext();
                return !this.buffer.isEmpty();
            }

            @Override
            public List<T> next() {
                this.loadNext();
                if (this.buffer.isEmpty()) {
                    throw new NoSuchElementException();
                }
                List list = this.buffer;
                this.buffer = new ArrayList(this.buffer.subList(Math.min(Buffer.this.step, this.buffer.size()), this.buffer.size()));
                return list;
            }

            @Override
            public void dispose() {
                this.it.dispose();
            }

            private void loadNext() {
                while (this.buffer.size() < Buffer.this.size && this.it.hasNext()) {
                    this.buffer.add(this.it.nextChecked());
                }
            }
        };
    }
}

