/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.kool.internal.operators.single;

import com.github.davidmoten.guavamini.Preconditions;
import java.util.Optional;
import java.util.function.Function;
import org.davidmoten.kool.Maybe;
import org.davidmoten.kool.Single;

public final class SingleFlatMapMaybe<T, R>
implements Maybe<R> {
    private final Single<T> single;
    private final Function<? super T, ? extends Maybe<? extends R>> mapper;

    public SingleFlatMapMaybe(Single<T> single, Function<? super T, ? extends Maybe<? extends R>> mapper) {
        Preconditions.checkNotNull(mapper);
        this.single = single;
        this.mapper = mapper;
    }

    @Override
    public Optional<R> get() {
        T v = this.single.get();
        Maybe maybe = (Maybe)Preconditions.checkNotNull(this.mapper.apply(v), (String)"mapper cannot return null");
        return maybe.get();
    }
}

