/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.kool.internal.operators.single;

import com.github.davidmoten.guavamini.Preconditions;
import java.util.function.Function;
import org.davidmoten.kool.Single;
import org.davidmoten.kool.Stream;
import org.davidmoten.kool.StreamIterable;
import org.davidmoten.kool.StreamIterator;

public class SingleFlatMap<T, R>
implements Stream<R> {
    private final Function<? super T, ? extends StreamIterable<? extends R>> mapper;
    private final Single<T> single;

    public SingleFlatMap(Single<T> single, Function<? super T, ? extends StreamIterable<? extends R>> mapper) {
        this.single = single;
        this.mapper = mapper;
    }

    @Override
    public StreamIterator<R> iterator() {
        return new StreamIterator<R>(){
            StreamIterator<? extends R> it;
            boolean finished;

            @Override
            public boolean hasNext() {
                this.load();
                return this.it.hasNext();
            }

            @Override
            public R next() {
                this.load();
                return this.it.nextChecked();
            }

            @Override
            public void dispose() {
                this.finished = false;
                this.it.dispose();
                this.it = null;
            }

            private void load() {
                if (this.finished) {
                    throw new IllegalStateException("stream finished");
                }
                if (this.it == null) {
                    this.it = (StreamIterator)Preconditions.checkNotNull((Object)((StreamIterable)SingleFlatMap.this.mapper.apply(SingleFlatMap.this.single.get())).iterator());
                }
            }
        };
    }
}

