/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.kool;

import com.github.davidmoten.guavamini.Preconditions;
import org.davidmoten.kool.Single;

public final class SingleTester<T> {
    private T value;
    private Throwable error;

    SingleTester(Single<T> single) {
        try {
            this.value = single.get();
        }
        catch (Throwable e) {
            this.error = e;
        }
    }

    public SingleTester<T> assertValue(T v) {
        this.assertNoError();
        if (!v.equals(this.value)) {
            throw new AssertionError((Object)("single result " + this.value + " not equal to " + v));
        }
        return this;
    }

    public SingleTester<T> assertValueOnly(T value) {
        return this.assertValue(value);
    }

    public SingleTester<T> assertNoError() {
        if (this.error != null) {
            throw new AssertionError("no error expected but one found", this.error);
        }
        return this;
    }

    public SingleTester<T> assertError(Class<? extends Throwable> cls) {
        Preconditions.checkNotNull(cls, (String)"cls cannot be null");
        if (!cls.isInstance(this.error)) {
            throw new AssertionError((Object)("error expected of type " + cls + " but was of type " + this.error.getClass()));
        }
        return this;
    }

    public SingleTester<T> assertErrorMessage(String message) {
        Preconditions.checkNotNull((Object)message, (String)"message cannot be null");
        if (!message.equals(this.error.getMessage())) {
            throw new AssertionError((Object)("error expected with msg " + message + " but message was: " + this.error.getMessage()));
        }
        return this;
    }
}

