/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.kool;

import com.github.davidmoten.guavamini.Preconditions;

public class Notification<T> {
    private final Throwable error;
    private final T value;
    private static final Notification<Object> COMPLETE = new Notification<Object>(null, null);

    Notification(Throwable error, T value) {
        this.error = error;
        this.value = value;
    }

    public static <T> Notification<T> of(T value) {
        return new Notification<T>(null, value);
    }

    public static <T> Notification<T> complete() {
        return COMPLETE;
    }

    public static <T> Notification<T> error(Throwable error) {
        return new Notification<Object>(error, null);
    }

    public T value() {
        return (T)Preconditions.checkNotNull(this.value);
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public boolean isComplete() {
        return this.error == null && this.value == null;
    }

    public boolean isError() {
        return this.error != null;
    }

    public Throwable error() {
        return this.error;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.error == null ? 0 : this.error.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Notification other = (Notification)obj;
        if (this.error == null ? other.error != null : !this.error.equals(other.error)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

