/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.kool;

import java.util.Optional;
import org.davidmoten.kool.Maybe;

public final class MaybeTester<T> {
    private Optional<T> value;
    private Throwable error;

    public MaybeTester(Maybe<T> maybe) {
        try {
            this.value = maybe.get();
        }
        catch (Throwable e) {
            this.error = e;
        }
    }

    public void assertValue(T t) {
        this.assertNoError();
        if (!this.value.isPresent()) {
            throw new AssertionError((Object)("Value " + t + " expected but no value found"));
        }
        if (!this.value.get().equals(t)) {
            throw new AssertionError((Object)("Value " + t + " expected but found " + this.value.get()));
        }
    }

    public void assertNoValue() {
        this.assertNoError();
        if (this.value.isPresent()) {
            throw new AssertionError((Object)("Did not expect a value but found " + this.value.get()));
        }
    }

    public MaybeTester<T> assertNoError() {
        if (this.error != null) {
            throw new AssertionError("no error expected but one was found", this.error);
        }
        return this;
    }

    public MaybeTester<T> assertError(Class<? extends Throwable> cls) {
        if (this.error == null) {
            throw new AssertionError((Object)("error expected of type " + cls + " but no error was found"));
        }
        if (!cls.isInstance(this.error)) {
            throw new AssertionError((Object)("error expected of type " + cls + " but was of type " + this.error.getClass()));
        }
        return this;
    }

    public MaybeTester<T> assertErrorMessage(String message) {
        if (this.error == null) {
            throw new AssertionError((Object)"error expected but no error was found");
        }
        if (!message.equals(this.error.getMessage())) {
            throw new AssertionError((Object)("error expected with msg " + message + " but message was: " + this.error.getMessage()));
        }
        return this;
    }
}

