/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.kool;

import com.github.davidmoten.guavamini.Preconditions;

public final class Indexed<T> {
    private final T t;
    private final int index;

    private Indexed(T t, int index) {
        Preconditions.checkNotNull(t);
        this.t = t;
        this.index = index;
    }

    public static <T> Indexed<T> create(T t, int index) {
        return new Indexed<T>(t, index);
    }

    public T value() {
        return this.t;
    }

    public int index() {
        return this.index;
    }

    public Indexed<T> incrementIndex() {
        return new Indexed<T>(this.t, this.index + 1);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.index;
        result = 31 * result + this.t.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Indexed other = (Indexed)obj;
        if (this.index != other.index) {
            return false;
        }
        return this.t.equals(other.t);
    }

    public String toString() {
        return "Indexed[index=" + this.index + ", value=" + this.t + "]";
    }
}

