/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.kool.internal.operators.stream;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.NoSuchElementException;
import org.davidmoten.kool.Stream;
import org.davidmoten.kool.StreamIterator;

public final class FromBufferedReader
implements Stream<String> {
    private BufferedReader reader;

    public FromBufferedReader(BufferedReader reader) {
        this.reader = reader;
    }

    @Override
    public StreamIterator<String> iterator() {
        return new StreamIterator<String>(){
            String line;

            @Override
            public boolean hasNext() {
                this.load();
                return this.line != null;
            }

            private void load() {
                if (this.line == null && FromBufferedReader.this.reader != null) {
                    try {
                        boolean hasNext;
                        this.line = FromBufferedReader.this.reader.readLine();
                        boolean bl = hasNext = this.line != null;
                        if (!hasNext) {
                            FromBufferedReader.this.reader = null;
                        }
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
            }

            @Override
            public String next() {
                this.load();
                if (this.line == null) {
                    this.dispose();
                    throw new NoSuchElementException();
                }
                String s = this.line;
                this.line = null;
                return s;
            }

            @Override
            public void dispose() {
                FromBufferedReader.this.reader = null;
                this.line = null;
            }
        };
    }
}

