/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.kool.internal.operators.stream;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.davidmoten.kool.Stream;
import org.davidmoten.kool.StreamIterator;
import org.davidmoten.kool.function.BiPredicate;

public final class BufferWithPredicate<T>
implements Stream<List<T>> {
    private final BiPredicate<? super List<T>, ? super T> condition;
    private final boolean emitRemainder;
    private final boolean until;
    private final Stream<T> source;

    public BufferWithPredicate(BiPredicate<? super List<T>, ? super T> condition, boolean emitRemainder, boolean until, Stream<T> source) {
        this.condition = condition;
        this.emitRemainder = emitRemainder;
        this.until = until;
        this.source = source;
    }

    @Override
    public StreamIterator<List<T>> iterator() {
        return new StreamIterator<List<T>>(){
            StreamIterator<T> it;
            List<T> buffer;
            List<T> nextBuffer;
            boolean ready;
            {
                this.it = BufferWithPredicate.this.source.iteratorNullChecked();
                this.buffer = new ArrayList();
                this.nextBuffer = new ArrayList();
            }

            @Override
            public boolean hasNext() {
                this.loadNext();
                return this.ready;
            }

            @Override
            public List<T> next() {
                this.loadNext();
                if (!this.ready) {
                    throw new NoSuchElementException();
                }
                List list = this.buffer;
                this.buffer = this.nextBuffer;
                this.nextBuffer = new ArrayList();
                this.ready = false;
                return list;
            }

            @Override
            public void dispose() {
                this.it.dispose();
            }

            private void loadNext() {
                while (!this.ready && this.it.hasNext()) {
                    Object t = this.it.nextNullChecked();
                    boolean b = BufferWithPredicate.this.condition.testUnchecked(this.buffer, t);
                    if (!BufferWithPredicate.this.until) {
                        if (b) {
                            this.buffer.add(t);
                            continue;
                        }
                        this.ready = true;
                        this.nextBuffer.add(t);
                        continue;
                    }
                    if (b) {
                        this.ready = true;
                        this.nextBuffer.add(t);
                        continue;
                    }
                    this.buffer.add(t);
                }
                if (!this.ready) {
                    if (BufferWithPredicate.this.emitRemainder && !this.buffer.isEmpty()) {
                        this.ready = true;
                    }
                } else {
                    this.ready = true;
                }
            }
        };
    }
}

