/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.kool.internal.operators.maybe;

import java.util.NoSuchElementException;
import java.util.Optional;
import org.davidmoten.kool.Maybe;
import org.davidmoten.kool.Stream;
import org.davidmoten.kool.StreamIterator;

public final class MaybeToStream<T>
implements Stream<T> {
    private final Maybe<T> maybe;

    public MaybeToStream(Maybe<T> maybe) {
        this.maybe = maybe;
    }

    @Override
    public StreamIterator<T> iterator() {
        return new StreamIterator<T>(){
            Optional<T> value;
            boolean finished;

            @Override
            public boolean hasNext() {
                this.load();
                if (this.finished) {
                    return false;
                }
                return this.value.isPresent();
            }

            @Override
            public T next() {
                this.load();
                if (this.finished) {
                    throw new NoSuchElementException();
                }
                if (this.value.isPresent()) {
                    this.finished = true;
                    Object v = this.value.get();
                    this.value = null;
                    return v;
                }
                this.value = null;
                this.finished = true;
                throw new NoSuchElementException();
            }

            @Override
            public void dispose() {
            }

            private void load() {
                if (!this.finished && this.value == null) {
                    this.value = MaybeToStream.this.maybe.get();
                }
            }
        };
    }
}

