/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.kool.internal.operators.maybe;

import java.util.Optional;
import org.davidmoten.kool.Maybe;
import org.davidmoten.kool.StreamIterator;

public final class MaybeIterator<T>
implements StreamIterator<T> {
    private final Maybe<T> maybe;
    private Optional<T> value;
    private boolean finished;

    public MaybeIterator(Maybe<T> maybe) {
        this.maybe = maybe;
    }

    @Override
    public boolean hasNext() {
        this.load();
        return !this.finished && this.value.isPresent();
    }

    @Override
    public T next() {
        this.load();
        try {
            if (this.finished) {
                throw new RuntimeException("stream is finished");
            }
            this.finished = true;
            T t = this.value.get();
            return t;
        }
        finally {
            this.dispose();
        }
    }

    @Override
    public void dispose() {
        this.finished = true;
        this.value = null;
    }

    private void load() {
        if (!this.finished && this.value == null) {
            this.value = this.maybe.get();
        }
    }
}

