/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.kool.internal.operators.maybe;

import com.github.davidmoten.guavamini.Preconditions;
import java.util.Optional;
import org.davidmoten.kool.Maybe;
import org.davidmoten.kool.function.Function;

public final class MaybeFlatMapMaybe<T, R>
implements Maybe<R> {
    private final Maybe<T> maybe;
    private final Function<? super T, ? extends Maybe<? extends R>> mapper;

    public MaybeFlatMapMaybe(Maybe<T> maybe, Function<? super T, ? extends Maybe<? extends R>> mapper) {
        this.maybe = maybe;
        this.mapper = mapper;
    }

    @Override
    public Optional<R> get() {
        Optional<T> v = this.maybe.get();
        if (v.isPresent()) {
            return ((Maybe)Preconditions.checkNotNull(this.mapper.applyUnchecked(v.get()), (String)"mapper cannot return null")).get();
        }
        return Optional.empty();
    }
}

