/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.kool;

import com.github.davidmoten.guavamini.Preconditions;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;
import org.davidmoten.kool.Collector;
import org.davidmoten.kool.Emitter;
import org.davidmoten.kool.Indexed;
import org.davidmoten.kool.Maybe;
import org.davidmoten.kool.Notification;
import org.davidmoten.kool.Plugins;
import org.davidmoten.kool.RetryWhenBuilder;
import org.davidmoten.kool.Single;
import org.davidmoten.kool.Statistics;
import org.davidmoten.kool.StreamIterable;
import org.davidmoten.kool.StreamIterator;
import org.davidmoten.kool.Tester;
import org.davidmoten.kool.function.Action;
import org.davidmoten.kool.function.BiConsumer;
import org.davidmoten.kool.function.BiFunction;
import org.davidmoten.kool.function.BiPredicate;
import org.davidmoten.kool.function.Consumer;
import org.davidmoten.kool.function.Function;
import org.davidmoten.kool.function.Predicate;
import org.davidmoten.kool.function.Predicates;
import org.davidmoten.kool.internal.operators.stream.All;
import org.davidmoten.kool.internal.operators.stream.Any;
import org.davidmoten.kool.internal.operators.stream.Buffer;
import org.davidmoten.kool.internal.operators.stream.BufferWithPredicate;
import org.davidmoten.kool.internal.operators.stream.Cache;
import org.davidmoten.kool.internal.operators.stream.Collect;
import org.davidmoten.kool.internal.operators.stream.Concat;
import org.davidmoten.kool.internal.operators.stream.Count;
import org.davidmoten.kool.internal.operators.stream.Defer;
import org.davidmoten.kool.internal.operators.stream.Dematerialize;
import org.davidmoten.kool.internal.operators.stream.Distinct;
import org.davidmoten.kool.internal.operators.stream.DistinctUntilChanged;
import org.davidmoten.kool.internal.operators.stream.DoOnComplete;
import org.davidmoten.kool.internal.operators.stream.DoOnDispose;
import org.davidmoten.kool.internal.operators.stream.DoOnEmpty;
import org.davidmoten.kool.internal.operators.stream.DoOnError;
import org.davidmoten.kool.internal.operators.stream.DoOnNext;
import org.davidmoten.kool.internal.operators.stream.DoOnStart;
import org.davidmoten.kool.internal.operators.stream.Filter;
import org.davidmoten.kool.internal.operators.stream.First;
import org.davidmoten.kool.internal.operators.stream.FlatMap;
import org.davidmoten.kool.internal.operators.stream.FromArray;
import org.davidmoten.kool.internal.operators.stream.FromArrayDouble;
import org.davidmoten.kool.internal.operators.stream.FromArrayFloat;
import org.davidmoten.kool.internal.operators.stream.FromArrayInt;
import org.davidmoten.kool.internal.operators.stream.FromBufferedReader;
import org.davidmoten.kool.internal.operators.stream.FromChars;
import org.davidmoten.kool.internal.operators.stream.FromInputStream;
import org.davidmoten.kool.internal.operators.stream.FromReader;
import org.davidmoten.kool.internal.operators.stream.Generate;
import org.davidmoten.kool.internal.operators.stream.IgnoreDisposalError;
import org.davidmoten.kool.internal.operators.stream.IsEmpty;
import org.davidmoten.kool.internal.operators.stream.Last;
import org.davidmoten.kool.internal.operators.stream.Map;
import org.davidmoten.kool.internal.operators.stream.Materialize;
import org.davidmoten.kool.internal.operators.stream.Max;
import org.davidmoten.kool.internal.operators.stream.MergeInterleaved;
import org.davidmoten.kool.internal.operators.stream.PowerSet;
import org.davidmoten.kool.internal.operators.stream.PrependOne;
import org.davidmoten.kool.internal.operators.stream.Range;
import org.davidmoten.kool.internal.operators.stream.RangeLong;
import org.davidmoten.kool.internal.operators.stream.ReduceNoInitialValue;
import org.davidmoten.kool.internal.operators.stream.ReduceWithInitialValueSupplier;
import org.davidmoten.kool.internal.operators.stream.Repeat;
import org.davidmoten.kool.internal.operators.stream.RepeatElement;
import org.davidmoten.kool.internal.operators.stream.RepeatLast;
import org.davidmoten.kool.internal.operators.stream.RetryWhen;
import org.davidmoten.kool.internal.operators.stream.Reverse;
import org.davidmoten.kool.internal.operators.stream.Skip;
import org.davidmoten.kool.internal.operators.stream.SkipUntil;
import org.davidmoten.kool.internal.operators.stream.Sorted;
import org.davidmoten.kool.internal.operators.stream.Split;
import org.davidmoten.kool.internal.operators.stream.SwitchOnEmpty;
import org.davidmoten.kool.internal.operators.stream.SwitchOnError;
import org.davidmoten.kool.internal.operators.stream.Take;
import org.davidmoten.kool.internal.operators.stream.TakeLast;
import org.davidmoten.kool.internal.operators.stream.TakeWithPredicate;
import org.davidmoten.kool.internal.operators.stream.ToMaybe;
import org.davidmoten.kool.internal.operators.stream.ToSingle;
import org.davidmoten.kool.internal.operators.stream.Transform;
import org.davidmoten.kool.internal.operators.stream.TransformMaybe;
import org.davidmoten.kool.internal.operators.stream.TransformSingle;
import org.davidmoten.kool.internal.operators.stream.Using;
import org.davidmoten.kool.internal.operators.stream.Zip;
import org.davidmoten.kool.internal.util.Exceptions;
import org.davidmoten.kool.internal.util.Iterables;
import org.davidmoten.kool.internal.util.Permutations;
import org.davidmoten.kool.internal.util.StreamImpl;
import org.davidmoten.kool.internal.util.StreamUtils;

public interface Stream<T>
extends StreamIterable<T> {
    public static final int DEFAULT_BUFFER_SIZE = 16;
    public static final int DEFAULT_BYTE_BUFFER_SIZE = 8192;
    public static final Consumer<Closeable> CLOSEABLE_CLOSER = new Consumer<Closeable>(){

        @Override
        public void accept(Closeable c) {
            try {
                c.close();
            }
            catch (IOException e) {
                Plugins.onError(e);
            }
        }
    };

    public static <T> Stream<T> create(Iterable<T> source) {
        return new StreamImpl<T>(source);
    }

    public static <T> Stream<T> of(T t) {
        return Stream.create(Collections.singleton(t));
    }

    public static <T> Stream<T> of(T t1, T t2) {
        return Stream.create(Iterables.ofNoCopy(t1, t2));
    }

    public static <T> Stream<T> of(T t1, T t2, T t3) {
        return Stream.create(Iterables.ofNoCopy(t1, t2, t3));
    }

    public static <T> Stream<T> of(T t1, T t2, T t3, T t4) {
        return Stream.create(Iterables.ofNoCopy(t1, t2, t3, t4));
    }

    public static <T> Stream<T> of(T t1, T t2, T t3, T t4, T t5) {
        return Stream.create(Iterables.ofNoCopy(t1, t2, t3, t4, t5));
    }

    public static <T> Stream<T> of(T t1, T t2, T t3, T t4, T t5, T t6) {
        return Stream.create(Iterables.ofNoCopy(t1, t2, t3, t4, t5, t6));
    }

    public static <T> Stream<T> of(T t1, T t2, T t3, T t4, T t5, T t6, T t7) {
        return Stream.create(Iterables.ofNoCopy(t1, t2, t3, t4, t5, t6, t7));
    }

    public static <T> Stream<T> of(T t1, T t2, T t3, T t4, T t5, T t6, T t7, T t8) {
        return Stream.create(Iterables.ofNoCopy(t1, t2, t3, t4, t5, t6, t7, t8));
    }

    public static <T> Stream<T> error(final Throwable e) {
        return Stream.from(new StreamIterable<T>(){

            @Override
            public StreamIterator<T> iterator() {
                return (StreamIterator)Exceptions.rethrow(e);
            }
        });
    }

    public static Stream<Integer> chars(CharSequence s) {
        return Stream.chars(s, 0, s.length());
    }

    public static Stream<Integer> chars(CharSequence s, int fromIndex, int toIndex) {
        return new FromChars(s, fromIndex, toIndex);
    }

    public static <T> Stream<T> generate(Consumer<Emitter<T>> consumer) {
        return new Generate<T>(consumer);
    }

    public static <T, R> Stream<T> generate(Callable<R> factory, BiConsumer<R, Emitter<T>> consumer) {
        return Stream.defer(() -> {
            Object r = factory.call();
            return Stream.generate(e -> consumer.accept((Object)r, (Emitter)e));
        });
    }

    public static <T> Stream<T> error(final Callable<? extends Throwable> callable) {
        return Stream.from(new StreamIterable<T>(){

            @Override
            public StreamIterator<T> iterator() {
                return (StreamIterator)Exceptions.rethrow(callable);
            }
        });
    }

    public static <T> Stream<T> from(Iterable<T> iterable) {
        return Stream.create(iterable);
    }

    public static Stream<String> from(Reader reader) {
        return new FromReader(reader, 16);
    }

    public static Stream<String> from(Reader reader, int bufferSize) {
        return new FromReader(reader, bufferSize);
    }

    public static Stream<String> from(InputStream in, Charset charset, int bufferSize) {
        return new FromReader(new InputStreamReader(in, charset), bufferSize);
    }

    public static Stream<String> from(InputStream in, Charset charset) {
        return Stream.from(in, charset, 16);
    }

    public static Stream<String> from(InputStream in) {
        return Stream.from(in, StandardCharsets.UTF_8);
    }

    public static <T> Stream<T> fromArray(T[] array, int fromIndex, int toIndex) {
        return new FromArray<T>(array, fromIndex, toIndex);
    }

    public static <T> Stream<T> fromArray(T[] array) {
        if (array.length == 0) {
            return Stream.empty();
        }
        return Stream.fromArray(array, 0, array.length);
    }

    public static Stream<Integer> fromArray(int[] array, int fromIndex, int toIndex) {
        return new FromArrayInt(array, fromIndex, toIndex);
    }

    public static Stream<Integer> fromArray(int[] array) {
        if (array.length == 0) {
            return Stream.empty();
        }
        return Stream.fromArray(array, 0, array.length);
    }

    public static Stream<Double> fromArray(double[] array, int fromIndex, int toIndex) {
        return new FromArrayDouble(array, fromIndex, toIndex);
    }

    public static Stream<Double> fromArray(double[] array) {
        if (array.length == 0) {
            return Stream.empty();
        }
        return Stream.fromArray(array, 0, array.length);
    }

    public static Stream<Float> fromArray(float[] array, int fromIndex, int toIndex) {
        return new FromArrayFloat(array, fromIndex, toIndex);
    }

    public static Stream<Float> fromArray(float[] array) {
        if (array.length == 0) {
            return Stream.empty();
        }
        return Stream.fromArray(array, 0, array.length);
    }

    public static Stream<String> lines(BufferedReader reader) {
        return new FromBufferedReader(reader);
    }

    public static Stream<String> lines(Callable<BufferedReader> readerFactory) {
        return Stream.using(() -> {
            try {
                return (BufferedReader)readerFactory.call();
            }
            catch (Exception e) {
                return (BufferedReader)Exceptions.rethrow(e);
            }
        }, br -> Stream.lines(br));
    }

    public static Stream<String> lines(Callable<InputStream> inFactory, Charset charset) {
        return Stream.lines(() -> new BufferedReader(new InputStreamReader((InputStream)inFactory.call(), charset)));
    }

    public static Stream<String> lines(File file, Charset charset) {
        return Stream.using(() -> {
            try {
                return new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                throw new UncheckedIOException(e);
            }
        }, in -> Stream.lines(() -> in, charset));
    }

    public static Stream<String> lines(File file) {
        return Stream.lines(file, StandardCharsets.UTF_8);
    }

    public static Stream<String> linesFromResource(String resource, Charset charset) {
        return Stream.linesFromResource(Stream.class, resource, charset);
    }

    public static Stream<String> linesFromResource(Class<?> cls, String resource, Charset charset) {
        return Stream.lines(() -> cls.getResourceAsStream(resource), charset);
    }

    public static Stream<String> linesFromResource(String resource) {
        return Stream.linesFromResource(Stream.class, resource, StandardCharsets.UTF_8);
    }

    public static Stream<ByteBuffer> byteBuffers(Callable<? extends InputStream> provider, int bufferSize) {
        return Stream.using(provider, is -> Stream.byteBuffers(is));
    }

    public static Stream<ByteBuffer> byteBuffers(Callable<? extends InputStream> provider) {
        return Stream.byteBuffers(provider, 8192);
    }

    public static Stream<ByteBuffer> byteBuffers(InputStream in) {
        return Stream.byteBuffers(in, 8192);
    }

    public static Stream<ByteBuffer> byteBuffers(InputStream in, int bufferSize) {
        return new FromInputStream(in, bufferSize);
    }

    public static Stream<byte[]> bytes(Callable<? extends InputStream> provider, int bufferSize) {
        return Stream.byteBuffers(provider, bufferSize).map(bb -> {
            byte[] b = new byte[bb.remaining()];
            bb.get(b);
            return b;
        });
    }

    public static Stream<byte[]> bytes(Callable<? extends InputStream> provider) {
        return Stream.bytes(provider, 8192);
    }

    public static Stream<byte[]> bytes(InputStream in, int bufferSize) {
        return Stream.byteBuffers(in, bufferSize).map(bb -> {
            byte[] b = new byte[bb.remaining()];
            bb.get(b);
            return b;
        });
    }

    public static Stream<byte[]> bytes(InputStream in) {
        return Stream.bytes(in, 16);
    }

    public static Stream<Integer> range(int start, int length) {
        return new Range(start, length);
    }

    public static Stream<Long> rangeLong(long start, long length) {
        return new RangeLong(start, length);
    }

    public static Stream<Long> ordinalsLong() {
        return Stream.rangeLong(1L, Long.MAX_VALUE);
    }

    public static Stream<Integer> ordinals() {
        return Stream.range(1, Integer.MAX_VALUE);
    }

    public static <T> Stream<T> defer(Callable<? extends Stream<? extends T>> provider) {
        return new Defer(provider);
    }

    public static <T> Stream<T> empty() {
        return StreamUtils.EmptyHolder.EMPTY;
    }

    public static <R, T> Stream<T> using(Callable<R> resourceFactory, Function<? super R, ? extends Stream<? extends T>> streamFactory, Consumer<? super R> closer) {
        return new Using(resourceFactory, streamFactory, closer);
    }

    public static <R extends Closeable, T> Stream<T> using(Callable<R> resourceFactory, Function<? super R, ? extends Stream<? extends T>> streamFactory) {
        return new Using(resourceFactory, streamFactory, CLOSEABLE_CLOSER);
    }

    public static <T> Stream<T> repeatElement(T t) {
        return Stream.repeatElement(t, Long.MAX_VALUE);
    }

    public static <T> Stream<T> repeatElement(T t, long count) {
        return new RepeatElement<T>(t, count);
    }

    @SafeVarargs
    public static <T> Stream<T> merge(Stream<? extends T> ... streams) {
        return new MergeInterleaved<T>(streams);
    }

    public static Stream<Integer> interval(long duration, TimeUnit unit) {
        return Stream.range(1, Integer.MAX_VALUE).doOnNext(x -> unit.sleep(duration)).prepend(0);
    }

    public static InputStream inputStream(Stream<? extends byte[]> stream) {
        return StreamUtils.toInputStream(stream);
    }

    public static Stream<String> strings(Stream<? extends byte[]> stream, Charset charset, int bufferSize) {
        return Stream.defer(() -> Stream.from(new InputStreamReader(Stream.inputStream(stream), charset.newDecoder()), bufferSize));
    }

    public static Stream<String> strings(Stream<? extends byte[]> stream, Charset charset) {
        return Stream.strings(stream, charset, 16);
    }

    public static Stream<String> strings(Stream<? extends byte[]> stream) {
        return Stream.strings(stream, StandardCharsets.UTF_8);
    }

    default public Single<Boolean> isEmpty() {
        return new IsEmpty(this);
    }

    default public Single<Boolean> hasElements() {
        return this.isEmpty().map(x -> x == false);
    }

    default public Stream<T> sorted(Comparator<? super T> comparator) {
        return new Sorted<T>(comparator, this);
    }

    default public Stream<T> sorted() {
        return this.sorted(Comparator.naturalOrder());
    }

    default public <R> Stream<R> map(Function<? super T, ? extends R> function) {
        return new Map<T, R>(function, this);
    }

    default public Maybe<T> reduce(BiFunction<? super T, ? super T, ? extends T> reducer) {
        return new ReduceNoInitialValue<T>(reducer, this);
    }

    default public <R> Single<R> reduce(R initialValue, BiFunction<? super R, ? super T, ? extends R> reducer) {
        return this.reduceWithFactory(() -> initialValue, reducer);
    }

    default public <R> Single<R> reduceWithFactory(Callable<? extends R> initialValueFactory, BiFunction<? super R, ? super T, ? extends R> reducer) {
        return new ReduceWithInitialValueSupplier<R, T>(initialValueFactory, reducer, this);
    }

    default public <R> Single<Integer> sumInt(Function<? super T, Integer> mapper) {
        return this.reduce(0, (x, y) -> x + (Integer)mapper.apply(y));
    }

    default public <R> Single<Long> sumLong(Function<? super T, Long> mapper) {
        return this.reduce(0L, (x, y) -> x + (Long)mapper.apply(y));
    }

    default public <R> Single<Double> sumDouble(Function<? super T, Double> mapper) {
        return this.reduce(0.0, (x, y) -> x + (Double)mapper.apply(y));
    }

    default public <R> Single<R> collect(Callable<? extends R> factory, BiConsumer<? super R, ? super T> collector) {
        return new Collect<T, R>(factory, collector, this);
    }

    default public <R> Single<R> collect(Collector<T, R> collector) {
        return this.reduceWithFactory(collector, collector);
    }

    default public <A, R> Single<R> collect(final java.util.stream.Collector<T, A, R> collector) {
        final Supplier<A> supplier = collector.supplier();
        final java.util.function.BiConsumer<A, T> accumulator = collector.accumulator();
        Function finisher = new Function<A, R>(){
            final java.util.function.Function<A, R> finisher;
            {
                this.finisher = collector.finisher();
            }

            @Override
            public R apply(A a) throws Exception {
                return this.finisher.apply(a);
            }
        };
        return this.collect(new Collector<T, A>(){

            @Override
            public A call() throws Exception {
                return supplier.get();
            }

            @Override
            public A apply(A a, T t) throws Exception {
                accumulator.accept(a, t);
                return a;
            }
        }).map(finisher);
    }

    default public <M extends java.util.Map<K, D>, K, V, D extends Collection<V>> Single<M> groupBy(Callable<M> mapFactory, Function<? super T, ? extends K> keySelector, Function<? super T, ? extends V> valueSelector, Callable<D> collectionFactory) {
        return this.collect(mapFactory, (map, t) -> {
            Object k = keySelector.apply(t);
            Object v = valueSelector.apply(t);
            Collection x = (Collection)map.get(k);
            if (x == null) {
                try {
                    x = (Collection)collectionFactory.call();
                    map.put(k, x);
                }
                catch (Exception e) {
                    Exceptions.rethrow(e);
                }
            }
            x.add(v);
        });
    }

    default public <M extends java.util.Map<K, List<V>>, K, V> Single<M> groupByList(Callable<M> mapFactory, Function<? super T, ? extends K> keySelector, Function<? super T, ? extends V> valueSelector) {
        return this.groupBy(mapFactory, keySelector, valueSelector, ArrayList::new);
    }

    default public <M extends java.util.Map<K, Set<V>>, K, V> Single<M> groupBySet(Callable<M> mapFactory, Function<? super T, ? extends K> keySelector, Function<? super T, ? extends V> valueSelector) {
        return this.groupBy(mapFactory, keySelector, valueSelector, HashSet::new);
    }

    default public <M extends java.util.Map<K, List<T>>, K> Single<M> groupByList(Callable<M> mapFactory, Function<? super T, ? extends K> keySelector) {
        return this.groupByList(mapFactory, keySelector, Function.identity());
    }

    default public <M extends java.util.Map<K, Set<T>>, K> Single<M> groupBySet(Callable<M> mapFactory, Function<? super T, ? extends K> keySelector) {
        return this.groupBySet(mapFactory, keySelector, Function.identity());
    }

    default public <K> Single<java.util.Map<K, List<T>>> groupByList(Function<? super T, ? extends K> keySelector) {
        return this.groupByList(HashMap::new, keySelector);
    }

    default public <K> Single<java.util.Map<K, Set<T>>> groupBySet(Function<? super T, ? extends K> keySelector) {
        return this.groupBySet(HashMap::new, keySelector);
    }

    default public Single<T> single() {
        return new ToSingle(this);
    }

    default public Single<List<T>> toList() {
        return this.toList(16);
    }

    default public Single<Set<T>> toSet() {
        return this.toSet(16);
    }

    default public Single<Set<T>> toSet(int sizeHint) {
        return this.collect(() -> new HashSet(sizeHint), (set, x) -> set.add(x));
    }

    default public Single<List<T>> toList(int sizeHint) {
        return this.collect(() -> new ArrayList(sizeHint), (list, x) -> list.add(x));
    }

    default public Stream<T> filter(Predicate<? super T> function) {
        if (function == Predicates.alwaysTrue()) {
            return this;
        }
        return new Filter<T>(function, this);
    }

    default public Single<Boolean> exists(Predicate<? super T> function) {
        return this.filter(function).isEmpty().map(x -> x == false);
    }

    default public void forEach() {
        this.count().get();
    }

    default public void go() {
        this.forEach();
    }

    default public void start() {
        this.forEach();
    }

    default public void forEach2(Consumer<? super T> consumer) {
        this.doOnNext(consumer).count().get();
    }

    default public Stream<T> println() {
        return this.doOnNext(System.out::println);
    }

    default public Single<Long> count() {
        return new Count(this);
    }

    default public Stream<T> prepend(T value) {
        return new PrependOne<T>(value, this);
    }

    default public Stream<T> prepend(T[] values) {
        return new Concat<T>(Stream.create(Iterables.fromArray(values)), this);
    }

    default public Stream<T> prepend(StreamIterable<? extends T> values) {
        return new Concat<T>(values, this);
    }

    default public Stream<T> concatWith(StreamIterable<? extends T> values) {
        return new Concat<T>(this, values);
    }

    default public <R> Stream<R> flatMap(Function<? super T, ? extends StreamIterable<? extends R>> function) {
        return new FlatMap(function, this);
    }

    default public Maybe<T> findFirst(Predicate<? super T> predicate) {
        if (predicate == Predicates.alwaysFalse()) {
            return Maybe.empty();
        }
        return this.filter(predicate).first();
    }

    default public Maybe<T> first() {
        return new First(this);
    }

    default public Stream<T> doOnNext(Consumer<? super T> consumer) {
        return new DoOnNext<T>(consumer, this);
    }

    default public Stream<T> doOnError(Consumer<? super Throwable> consumer) {
        return new DoOnError(consumer, this);
    }

    default public Stream<T> doOnComplete(Action action) {
        return new DoOnComplete(action, this);
    }

    default public Stream<T> doOnDispose(Action action) {
        return this.doBeforeDispose(action);
    }

    default public Stream<T> doBeforeDispose(Action action) {
        return new DoOnDispose(action, this, true);
    }

    default public Stream<T> doAfterDispose(Action action) {
        return new DoOnDispose(action, this, false);
    }

    default public Stream<T> doOnEmpty(Action action) {
        return new DoOnEmpty(this, action);
    }

    default public Maybe<T> last() {
        return new Last(this);
    }

    default public Maybe<T> get(int index) {
        return this.take(index + 1).last();
    }

    default public Stream<T> take(long n) {
        return new Take(n, this);
    }

    default public Stream<T> takeLast(long n) {
        return new TakeLast(this, n);
    }

    default public <R> Stream<R> transform(Function<? super Stream<T>, ? extends Stream<? extends R>> transformer) {
        return new Transform(transformer, this);
    }

    default public <R> Single<R> transformSingle(Function<? super Stream<T>, ? extends Single<? extends R>> transformer) {
        return new TransformSingle(transformer, this);
    }

    default public <R> Maybe<R> transformMaybe(Function<? super Stream<T>, ? extends Maybe<? extends R>> transformer) {
        return new TransformMaybe(transformer, this);
    }

    default public <R> Stream<R> compose(Function<? super Stream<T>, ? extends Stream<? extends R>> transformer) {
        return this.transform(transformer);
    }

    default public <R> Single<R> composeSingle(Function<? super Stream<T>, ? extends Single<? extends R>> transformer) {
        return this.transformSingle(transformer);
    }

    default public <R> Maybe<R> composeMaybe(Function<? super Stream<T>, ? extends Maybe<? extends R>> transformer) {
        return this.transformMaybe(transformer);
    }

    default public Stream<T> switchOnError(Function<? super Throwable, ? extends Stream<? extends T>> function) {
        return new SwitchOnError(function, this);
    }

    default public Stream<T> switchOnEmpty(Callable<? extends Stream<T>> factory) {
        return new SwitchOnEmpty(this, factory);
    }

    default public <R, S> Stream<S> zipWith(Stream<? extends R> stream, BiFunction<T, R, S> combiner) {
        return new Zip<R, S, T>(this, stream, combiner);
    }

    default public java.util.stream.Stream<T> toStreamJava() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    default public <K, V> Single<java.util.Map<K, V>> toMap(Function<? super T, ? extends K> keyFunction, Function<? super T, ? extends V> valueFunction) {
        return this.collect(HashMap::new, (m, item) -> m.put(keyFunction.apply(item), valueFunction.apply(item)));
    }

    default public Single<String> join(String delimiter) {
        return this.collect(() -> new StringBuilder(), (b, x) -> {
            if (b.length() > 0) {
                b.append(delimiter);
            }
            b.append(x);
        }).map(b -> b.toString());
    }

    default public Stream<String> split(String delimiter) {
        return new Split(delimiter, this);
    }

    default public Tester<T> test() {
        return new Tester(this);
    }

    default public Stream<List<T>> buffer(int size) {
        return this.buffer(size, size);
    }

    default public Stream<List<T>> buffer(int size, int step) {
        return new Buffer(this, size, step);
    }

    default public Stream<T> skip(int size) {
        return new Skip(size, this);
    }

    default public Stream<T> skipUntil(Predicate<? super T> predicate) {
        return new SkipUntil<T>(this, predicate, false);
    }

    default public Stream<T> skipWhile(Predicate<? super T> predicate) {
        return new SkipUntil<T>(this, predicate, true);
    }

    default public Stream<T> repeat(long count) {
        return new Repeat(count, this);
    }

    default public Stream<T> repeat() {
        return this.repeat(Long.MAX_VALUE);
    }

    default public Stream<T> takeUntil(Predicate<? super T> predicate) {
        return new TakeWithPredicate<T>(predicate, this, true);
    }

    default public Stream<T> takeWhile(Predicate<? super T> predicate) {
        return new TakeWithPredicate<T>(predicate, this, false);
    }

    default public Stream<List<T>> bufferWhile(BiPredicate<? super List<T>, ? super T> condition, boolean emitRemainder) {
        return new BufferWithPredicate<T>(condition, emitRemainder, false, this);
    }

    default public Stream<List<T>> bufferUntil(BiPredicate<? super List<T>, ? super T> condition, boolean emitRemainder) {
        return new BufferWithPredicate<T>(condition, emitRemainder, true, this);
    }

    default public Stream<Indexed<T>> mapWithIndex(int startIndex) {
        return Stream.defer(() -> {
            int[] index = new int[]{startIndex};
            return this.map(x -> {
                int n = index[0];
                index[0] = n + 1;
                return Indexed.create(x, n);
            });
        });
    }

    default public Stream<Indexed<T>> mapWithIndex() {
        return this.mapWithIndex(0);
    }

    default public Stream<T> cache() {
        return new Cache(this);
    }

    default public Stream<T> every(long n, BiConsumer<Long, T> action) {
        return Stream.defer(() -> {
            long[] index = new long[1];
            return this.doOnNext(x -> {
                index[0] = index[0] + 1L;
                if (index[0] % n == 0L) {
                    action.accept(index[0], x);
                }
            });
        });
    }

    default public Stream<T> ignoreDisposalError(Consumer<? super Throwable> action) {
        Preconditions.checkNotNull(action);
        return new IgnoreDisposalError(this, action);
    }

    default public Stream<T> ignoreDisposalError() {
        return new IgnoreDisposalError(this, null);
    }

    default public Maybe<T> max(Comparator<? super T> comparator) {
        return new Max<T>(this, comparator, false);
    }

    default public Maybe<T> min(Comparator<? super T> comparator) {
        return new Max<T>(this, comparator, true);
    }

    default public Single<Boolean> all(Predicate<? super T> predicate) {
        return new All<T>(this, predicate);
    }

    default public Single<Boolean> any(Predicate<? super T> predicate) {
        return new Any<T>(this, predicate);
    }

    default public <R> Stream<R> cast(Class<R> cls) {
        Preconditions.checkNotNull(cls);
        return this;
    }

    default public Single<Boolean> contains(T value) {
        Preconditions.checkNotNull(value);
        return this.any(x -> value.equals(x));
    }

    default public Stream<T> distinctUntilChanged() {
        return this.distinctUntilChanged(Function.identity());
    }

    default public <K> Stream<T> distinct(Function<? super T, K> keySelector) {
        return new Distinct<T, K>(this, keySelector);
    }

    default public Stream<T> distinct() {
        return this.distinct(Function.identity());
    }

    default public <K> Stream<T> distinctUntilChanged(Function<? super T, K> keySelector) {
        return new DistinctUntilChanged<T, K>(this, keySelector);
    }

    default public Maybe<T> maybe() {
        return new ToMaybe(this);
    }

    default public <R> R to(Function<? super Stream<T>, R> mapper) {
        return mapper.applyUnchecked(this);
    }

    default public Stream<T> printStackTrace() {
        return this.doOnError(Throwable::printStackTrace);
    }

    default public Stream<Notification<T>> materialize() {
        return new Materialize(this);
    }

    default public <R> Stream<R> dematerialize(Function<? super T, Notification<? extends R>> function) {
        return new Dematerialize<T, R>(this, function);
    }

    default public Stream<T> reverse() {
        return new Reverse(this);
    }

    default public Stream<T> doOnStart(Action action) {
        return new DoOnStart(this, action);
    }

    default public Stream<T> delayStart(long duration, TimeUnit unit) {
        return this.doOnStart(() -> unit.sleep(duration));
    }

    default public Stream<T> mergeWith(Stream<? extends T> stream) {
        return Stream.merge(this, stream);
    }

    default public Stream<T> retryWhen(Function<? super Throwable, ? extends Single<?>> function) {
        return new RetryWhen(this, function);
    }

    default public RetryWhenBuilder<T> retryWhen() {
        return new RetryWhenBuilder(this);
    }

    default public Stream<T> repeatLast(long count) {
        if (count == 0L) {
            return this;
        }
        return new RepeatLast(this, count);
    }

    default public <R> Stream<R> scan(final R initialValue, final BiFunction<? super R, ? super T, ? extends R> accumulator) {
        return Stream.defer(new Callable<Stream<R>>(){
            R r;
            {
                this.r = initialValue;
            }

            @Override
            public Stream<R> call() throws Exception {
                return Stream.this.map(x -> {
                    this.r = accumulator.apply(this.r, x);
                    return this.r;
                });
            }
        });
    }

    default public <R extends Number> Single<Statistics> statistics(Function<? super T, R> mapper) {
        return Stream.statistics(this.map(mapper));
    }

    default public Stream<T> repeatLast() {
        return this.repeatLast(Long.MAX_VALUE);
    }

    public static Stream<Set<Integer>> powerSet(int n) {
        return new PowerSet(n);
    }

    public static <T> Stream<List<Integer>> permutations(int size) {
        ArrayList<Integer> indexes = new ArrayList<Integer>(size);
        for (int i = 0; i < size; ++i) {
            indexes.add(i);
        }
        return Stream.from(Permutations.iterable(indexes)).scan(indexes, (a, swap) -> {
            ArrayList b = new ArrayList(a);
            b.set((Integer)swap.left(), a.get((Integer)swap.right()));
            b.set((Integer)swap.right(), a.get((Integer)swap.left()));
            return b;
        }).prepend(new ArrayList(indexes));
    }

    public static <T extends Number> Single<Statistics> statistics(Stream<T> stream) {
        return stream.reduce(new Statistics(), (stats, x) -> stats.add(x.doubleValue()));
    }
}

