/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.kool.internal.operators.stream;

import java.util.NoSuchElementException;
import org.davidmoten.kool.Stream;
import org.davidmoten.kool.StreamIterator;
import org.davidmoten.kool.function.Action;

public final class DoOnEmpty<T>
implements Stream<T> {
    private final Stream<T> stream;
    private final Action action;

    public DoOnEmpty(Stream<T> stream, Action action) {
        this.stream = stream;
        this.action = action;
    }

    @Override
    public StreamIterator<T> iterator() {
        return new StreamIterator<T>(){
            StreamIterator<T> it;
            boolean checkedForEmpty;
            {
                this.it = DoOnEmpty.this.stream.iteratorNullChecked();
            }

            @Override
            public boolean hasNext() {
                this.check();
                return this.it.hasNext();
            }

            @Override
            public T next() {
                this.check();
                if (this.it == null) {
                    throw new NoSuchElementException();
                }
                return this.it.nextNullChecked();
            }

            @Override
            public void dispose() {
                if (this.it != null) {
                    this.it.dispose();
                    this.it = null;
                }
            }

            private void check() {
                if (!this.checkedForEmpty) {
                    if (!this.it.hasNext()) {
                        DoOnEmpty.this.action.callUnchecked();
                    }
                    this.checkedForEmpty = true;
                }
            }
        };
    }
}

