/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.kool;

import com.github.davidmoten.guavamini.Preconditions;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.davidmoten.kool.MaybeTester;
import org.davidmoten.kool.RetryWhenBuilderMaybe;
import org.davidmoten.kool.Single;
import org.davidmoten.kool.Stream;
import org.davidmoten.kool.StreamIterable;
import org.davidmoten.kool.StreamIterator;
import org.davidmoten.kool.function.Consumer;
import org.davidmoten.kool.function.Function;
import org.davidmoten.kool.internal.operators.maybe.MaybeDefer;
import org.davidmoten.kool.internal.operators.maybe.MaybeDoOnEmpty;
import org.davidmoten.kool.internal.operators.maybe.MaybeDoOnError;
import org.davidmoten.kool.internal.operators.maybe.MaybeDoOnValue;
import org.davidmoten.kool.internal.operators.maybe.MaybeError;
import org.davidmoten.kool.internal.operators.maybe.MaybeFlatMap;
import org.davidmoten.kool.internal.operators.maybe.MaybeFlatMapMaybe;
import org.davidmoten.kool.internal.operators.maybe.MaybeFromCallable;
import org.davidmoten.kool.internal.operators.maybe.MaybeIsPresent;
import org.davidmoten.kool.internal.operators.maybe.MaybeIterator;
import org.davidmoten.kool.internal.operators.maybe.MaybeMap;
import org.davidmoten.kool.internal.operators.maybe.MaybeOrElse;
import org.davidmoten.kool.internal.operators.maybe.MaybeSwitchOnError;
import org.davidmoten.kool.internal.operators.maybe.MaybeToStream;
import org.davidmoten.kool.internal.util.MaybeImpl;

public interface Maybe<T>
extends StreamIterable<T> {
    public Optional<T> get();

    public static <T> Maybe<T> of(T value) {
        Preconditions.checkNotNull(value);
        return new MaybeImpl<T>(Optional.of(value));
    }

    public static <T> Maybe<T> fromOptional(Optional<? extends T> optional) {
        if (optional.isPresent()) {
            return Maybe.of(optional.get());
        }
        return Maybe.empty();
    }

    public static <T> Maybe<T> fromCallableNullable(Callable<? extends T> callable) {
        return new MaybeFromCallable<T>(callable, true);
    }

    public static <T> Maybe<T> fromCallable(Callable<? extends T> callable) {
        return new MaybeFromCallable<T>(callable, false);
    }

    public static <T> Maybe<T> ofNullable(T value) {
        if (value == null) {
            return Maybe.empty();
        }
        return new MaybeImpl<T>(Optional.of(value));
    }

    public static <T> Maybe<T> empty() {
        return MaybeImpl.EmptyHolder.INSTANCE;
    }

    public static <T> Maybe<T> defer(Callable<? extends Maybe<? extends T>> factory) {
        return new MaybeDefer(factory);
    }

    public static <T> Maybe<T> error(Callable<? extends Throwable> callable) {
        return new MaybeError(callable);
    }

    public static <T> Maybe<T> error(Throwable error) {
        return Maybe.error(() -> error);
    }

    default public <R> Maybe<R> map(Function<? super T, ? extends R> mapper) {
        return new MaybeMap<T, R>(this, mapper);
    }

    default public Stream<T> toStream() {
        return new MaybeToStream(this);
    }

    default public <R> Stream<R> flatMap(Function<? super T, ? extends StreamIterable<? extends R>> mapper) {
        return new MaybeFlatMap(this, mapper);
    }

    default public Maybe<T> doOnValue(Consumer<? super T> consumer) {
        return new MaybeDoOnValue<T>(consumer, this);
    }

    default public Maybe<T> doOnError(Consumer<? super Throwable> consumer) {
        return new MaybeDoOnError(consumer, this);
    }

    default public Maybe<T> doOnEmpty(Runnable action) {
        return new MaybeDoOnEmpty(this, action);
    }

    default public Single<T> orElse(T value) {
        return new MaybeOrElse<T>(this, value);
    }

    default public MaybeTester<T> test() {
        return new MaybeTester(this);
    }

    default public Single<Boolean> isPresent() {
        return new MaybeIsPresent(this);
    }

    @Override
    default public StreamIterator<T> iterator() {
        return new MaybeIterator(this);
    }

    default public <R> R to(Function<? super Maybe<T>, R> mapper) {
        return mapper.applyUnchecked(this);
    }

    default public void forEach() {
        this.get();
    }

    default public void start() {
        this.get();
    }

    default public void go() {
        this.get();
    }

    default public Maybe<T> switchOnError(Function<? super Throwable, ? extends Maybe<? extends T>> function) {
        return new MaybeSwitchOnError(this, function);
    }

    default public <R> Maybe<R> flatMapMaybe(Function<? super T, ? extends Maybe<? extends R>> mapper) {
        return new MaybeFlatMapMaybe(this, mapper);
    }

    default public Maybe<T> retryWhen(Function<? super Throwable, ? extends Single<?>> function) {
        return this.toStream().retryWhen(function).maybe();
    }

    default public RetryWhenBuilderMaybe<T> retryWhen() {
        return new RetryWhenBuilderMaybe(this);
    }

    default public Maybe<T> println() {
        return this.doOnValue(System.out::println);
    }

    default public Single<Long> count() {
        return this.toStream().count();
    }
}

