/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.kool.internal.util;

import com.github.davidmoten.guavamini.Preconditions;
import java.util.concurrent.Callable;
import org.davidmoten.kool.exceptions.UncheckedException;

public final class Exceptions {
    private Exceptions() {
    }

    public static <T> T rethrow(Throwable e) {
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        if (e instanceof Error) {
            throw (Error)e;
        }
        throw new UncheckedException(e);
    }

    public static <T> T rethrow(Callable<? extends Throwable> callable) {
        try {
            return Exceptions.rethrow((Throwable)Preconditions.checkNotNull((Object)callable.call()));
        }
        catch (Throwable e) {
            return Exceptions.rethrow(e);
        }
    }
}

