/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.kool.internal.operators.stream;

import org.davidmoten.kool.Notification;
import org.davidmoten.kool.Stream;
import org.davidmoten.kool.StreamIterable;
import org.davidmoten.kool.StreamIterator;
import org.davidmoten.kool.internal.util.BaseStreamIterator;

public final class Materialize<T>
implements Stream<Notification<T>> {
    private final Stream<T> stream;

    public Materialize(Stream<T> stream) {
        this.stream = stream;
    }

    @Override
    public StreamIterator<Notification<T>> iterator() {
        return new BaseStreamIterator<T, Notification<T>>(this.stream){
            boolean emittedTerminal;

            @Override
            public StreamIterator<T> init(StreamIterable<T> stream) {
                try {
                    return stream.iteratorNullChecked();
                }
                catch (Throwable e) {
                    this.emittedTerminal = true;
                    this.dispose();
                    this.next = Notification.error(e);
                    return null;
                }
            }

            @Override
            public void load() {
                if (!this.emittedTerminal) {
                    try {
                        if (this.it.hasNext()) {
                            this.next = Notification.of(this.it.nextNullChecked());
                        } else {
                            this.emittedTerminal = true;
                            this.dispose();
                            this.next = Notification.complete();
                        }
                    }
                    catch (Throwable e) {
                        this.emittedTerminal = true;
                        this.dispose();
                        this.next = Notification.error(e);
                    }
                }
            }
        };
    }
}

