/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.kool.internal.operators.stream;

import com.github.davidmoten.guavamini.Preconditions;
import org.davidmoten.kool.Stream;
import org.davidmoten.kool.StreamIterator;
import org.davidmoten.kool.function.Function;
import org.davidmoten.kool.internal.util.BaseStreamIterator;

public final class DistinctUntilChanged<T, K>
implements Stream<T> {
    private final Stream<T> stream;
    private final Function<? super T, K> keySelector;

    public DistinctUntilChanged(Stream<T> stream, Function<? super T, K> keySelector) {
        this.stream = stream;
        this.keySelector = keySelector;
    }

    @Override
    public StreamIterator<T> iterator() {
        return new BaseStreamIterator<T, T>(this.stream){
            K key;

            @Override
            public void load() {
                while (this.it.hasNext()) {
                    Object v = this.it.nextNullChecked();
                    Object k = Preconditions.checkNotNull(DistinctUntilChanged.this.keySelector.applyUnchecked(v));
                    if (k.equals(this.key)) continue;
                    this.key = k;
                    this.next = v;
                    break;
                }
            }

            @Override
            public void dispose() {
                super.dispose();
                this.key = null;
            }
        };
    }
}

