/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.kool.internal.operators.maybe;

import java.util.Optional;
import java.util.concurrent.Callable;
import org.davidmoten.kool.Maybe;
import org.davidmoten.kool.internal.util.Exceptions;

public final class MaybeFromCallable<T>
implements Maybe<T> {
    private final Callable<? extends T> callable;
    private final boolean nullable;

    public MaybeFromCallable(Callable<? extends T> callable, boolean nullable) {
        this.callable = callable;
        this.nullable = nullable;
    }

    @Override
    public Optional<T> get() {
        Object v = null;
        try {
            v = this.callable.call();
        }
        catch (Throwable e) {
            return (Optional)Exceptions.rethrow(e);
        }
        if (this.nullable) {
            return Optional.ofNullable(v);
        }
        if (v == null) {
            throw new NullPointerException("callable returned null!");
        }
        return Optional.of(v);
    }
}

