/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.kool.internal.util;

import org.davidmoten.kool.exceptions.BufferOverflowException;

public final class RingBuffer<T> {
    private T[] buffer;
    private int start;
    private int finish;

    public RingBuffer(int maxSize) {
        this.buffer = new Object[maxSize + 1];
        this.start = 0;
        this.finish = 0;
    }

    public RingBuffer<T> add(T value) {
        this.buffer[this.finish] = value;
        this.finish = (this.finish + 1) % this.buffer.length;
        if (this.finish == this.start) {
            throw new BufferOverflowException("buffer overflowed, maxSize=" + this.buffer.length);
        }
        return this;
    }

    public T poll() {
        if (this.start == this.finish) {
            return null;
        }
        T value = this.buffer[this.start];
        this.start = (this.start + 1) % this.buffer.length;
        return value;
    }

    public int size() {
        if (this.finish < this.start) {
            return this.finish + this.buffer.length - this.start;
        }
        return this.finish - this.start;
    }

    public RingBuffer<T> replay(int count) {
        if (count >= this.buffer.length - this.size()) {
            throw new IllegalArgumentException("cannot replay " + count + " items on a buffer of maxSize=" + (this.buffer.length - 1) + " where " + this.size() + " items still queued for reading");
        }
        this.start -= count;
        if (this.start < 0) {
            this.start += this.buffer.length;
        }
        return this;
    }

    public boolean isEmpty() {
        return this.start == this.finish;
    }
}

