/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.kool.internal.operators.stream;

import com.github.davidmoten.guavamini.Preconditions;
import java.util.NoSuchElementException;
import org.davidmoten.kool.Stream;
import org.davidmoten.kool.StreamIterator;

public final class RepeatLast<T>
implements Stream<T> {
    private final Stream<T> stream;
    private final long count;

    public RepeatLast(Stream<T> stream, long count) {
        Preconditions.checkArgument((count > 0L ? 1 : 0) != 0);
        this.stream = stream;
        this.count = count;
    }

    @Override
    public StreamIterator<T> iterator() {
        return new StreamIterator<T>(){
            StreamIterator<T> it;
            T next;
            long repeats;
            boolean loadNext;
            {
                this.it = RepeatLast.this.stream.iteratorNullChecked();
                this.repeats = RepeatLast.this.count;
                this.loadNext = true;
            }

            @Override
            public boolean hasNext() {
                this.load();
                return this.next != null && this.repeats > 0L;
            }

            @Override
            public T next() {
                this.load();
                if (this.next == null || this.repeats == 0L) {
                    this.dispose();
                    throw new NoSuchElementException();
                }
                if (this.it == null) {
                    --this.repeats;
                }
                this.loadNext = true;
                return this.next;
            }

            private void load() {
                if (this.it != null && this.loadNext) {
                    if (this.it.hasNext()) {
                        this.next = this.it.nextNullChecked();
                        this.loadNext = false;
                    } else {
                        this.it.dispose();
                        this.it = null;
                    }
                }
            }

            @Override
            public void dispose() {
                if (this.it != null) {
                    this.it.dispose();
                    this.next = null;
                    this.repeats = 0L;
                }
            }
        };
    }
}

