/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.kool;

import com.github.davidmoten.guavamini.Preconditions;
import java.util.Objects;

public final class Indexed<T> {
    private final T t;
    private final long index;

    private Indexed(T t, long index) {
        Preconditions.checkNotNull(t);
        this.t = t;
        this.index = index;
    }

    public static <T> Indexed<T> create(T t, long index) {
        return new Indexed<T>(t, index);
    }

    public T value() {
        return this.t;
    }

    public long index() {
        return this.index;
    }

    public int hashCode() {
        return Objects.hash(this.index, this.t);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Indexed other = (Indexed)obj;
        if (this.index != other.index) {
            return false;
        }
        return this.t.equals(other.t);
    }

    public String toString() {
        return "Indexed[index=" + this.index + ", value=" + this.t + "]";
    }
}

