/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.kool.internal.operators.stream;

import com.github.davidmoten.guavamini.Preconditions;
import java.util.NoSuchElementException;
import org.davidmoten.kool.Emitter;
import org.davidmoten.kool.Stream;
import org.davidmoten.kool.StreamIterator;
import org.davidmoten.kool.function.Consumer;

public final class Generate<T>
implements Stream<T> {
    private final Consumer<? super Emitter<T>> consumer;

    public Generate(Consumer<? super Emitter<T>> consumer) {
        this.consumer = consumer;
    }

    @Override
    public StreamIterator<T> iterator() {
        return new GenerateStreamIterator(this.consumer);
    }

    private static final class GenerateStreamIterator<T>
    implements StreamIterator<T>,
    Emitter<T> {
        private final Consumer<? super Emitter<T>> consumer;
        private T next;
        private boolean complete;

        public GenerateStreamIterator(Consumer<? super Emitter<T>> consumer) {
            this.consumer = consumer;
        }

        @Override
        public boolean hasNext() {
            this.load();
            return this.next != null;
        }

        @Override
        public T next() {
            this.load();
            T v = this.next;
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            this.next = null;
            return v;
        }

        @Override
        public void onNext(T t) {
            Preconditions.checkNotNull(t);
            if (this.next != null) {
                throw new IllegalArgumentException("emitter must only emit one event (onNext or OnComplete) per call to the consumer");
            }
            this.next = t;
        }

        @Override
        public void onComplete() {
            this.complete = true;
        }

        @Override
        public void dispose() {
        }

        private void load() {
            if (!this.complete && this.next == null) {
                this.consumer.acceptUnchecked(this);
                if (!this.complete && this.next == null) {
                    throw new IllegalStateException("must call either emitter.onNext or emitter.onComplete");
                }
            }
        }
    }
}

