/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.kool.internal.operators.stream;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.davidmoten.kool.Stream;
import org.davidmoten.kool.StreamIterator;
import org.davidmoten.kool.function.BiConsumer;
import org.davidmoten.kool.function.Consumer;
import org.davidmoten.kool.internal.util.Exceptions;

public final class FlatMapGenerator<T, R>
implements Stream<R> {
    private final BiConsumer<? super T, ? super Consumer<R>> generator;
    private final Stream<T> stream;
    private final Consumer<? super Consumer<R>> onFinish;

    public FlatMapGenerator(BiConsumer<? super T, ? super Consumer<R>> generator, Consumer<? super Consumer<R>> onFinish, Stream<T> stream) {
        this.generator = generator;
        this.onFinish = onFinish;
        this.stream = stream;
    }

    @Override
    public StreamIterator<R> iterator() {
        Iterator it = this.stream.iterator();
        return new StreamIterator<R>((StreamIterator)it){
            Deque<R> queue = new ArrayDeque();
            Consumer<R> consumer = x -> this.queue.offer(x);
            boolean onFinishCalled = false;
            final /* synthetic */ StreamIterator val$it;
            {
                this.val$it = streamIterator;
            }

            @Override
            public boolean hasNext() {
                this.load();
                return !this.queue.isEmpty();
            }

            @Override
            public R next() {
                this.load();
                if (this.queue.isEmpty()) {
                    throw new NoSuchElementException();
                }
                return this.queue.poll();
            }

            @Override
            public void dispose() {
                this.val$it.dispose();
            }

            private void load() {
                while (this.queue.isEmpty() && this.val$it.hasNext()) {
                    Object t = this.val$it.next();
                    try {
                        FlatMapGenerator.this.generator.accept(t, this.consumer);
                    }
                    catch (Exception e) {
                        Exceptions.rethrow(e);
                        return;
                    }
                }
                if (this.queue.isEmpty() && !this.onFinishCalled) {
                    try {
                        FlatMapGenerator.this.onFinish.accept(this.consumer);
                    }
                    catch (Exception e) {
                        Exceptions.rethrow(e);
                        return;
                    }
                    this.onFinishCalled = true;
                }
            }
        };
    }
}

