/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.kool.internal.operators.stream;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.davidmoten.kool.Stream;
import org.davidmoten.kool.StreamIterator;
import org.davidmoten.kool.function.BiPredicate;
import org.davidmoten.kool.function.Function;
import org.davidmoten.kool.internal.operators.stream.ReplayableStreamIterator;

public final class BufferWithPredicateAndStep<T>
implements Stream<List<T>> {
    private final BiPredicate<? super List<T>, ? super T> condition;
    private final boolean emitRemainder;
    private final boolean until;
    private final Stream<T> source;
    private final Function<? super List<T>, Integer> step;
    private final int maxReplay;

    public BufferWithPredicateAndStep(BiPredicate<? super List<T>, ? super T> condition, boolean emitRemainder, boolean until, Stream<T> source, Function<? super List<T>, Integer> step, int maxReplay) {
        this.condition = condition;
        this.emitRemainder = emitRemainder;
        this.until = until;
        this.source = source;
        this.step = step;
        this.maxReplay = maxReplay;
    }

    @Override
    public StreamIterator<List<T>> iterator() {
        return new StreamIterator<List<T>>(){
            ReplayableStreamIterator<T> it;
            List<T> buffer;
            List<T> nextBuffer;
            boolean ready;
            {
                this.it = new ReplayableStreamIterator(BufferWithPredicateAndStep.this.source.iteratorNullChecked(), BufferWithPredicateAndStep.this.maxReplay);
                this.buffer = new ArrayList();
                this.nextBuffer = new ArrayList();
            }

            @Override
            public boolean hasNext() {
                this.loadNext();
                return this.ready;
            }

            @Override
            public List<T> next() {
                this.loadNext();
                if (!this.ready) {
                    throw new NoSuchElementException();
                }
                List list = this.buffer;
                this.buffer = this.nextBuffer;
                this.nextBuffer = new ArrayList();
                this.ready = false;
                int offset = (Integer)BufferWithPredicateAndStep.this.step.applyUnchecked(list);
                int bufferSize = this.buffer.size();
                this.buffer.clear();
                if (offset > list.size()) {
                    int n = offset - list.size();
                    for (int i = 0; i < n - bufferSize && this.it.hasNext(); ++i) {
                        this.it.next();
                    }
                } else {
                    this.it.replay(list.size() - offset + bufferSize);
                }
                return list;
            }

            @Override
            public void dispose() {
                this.it.dispose();
            }

            private void loadNext() {
                while (!this.ready && this.it.hasNext()) {
                    Object t = this.it.nextNullChecked();
                    boolean b = BufferWithPredicateAndStep.this.condition.testUnchecked(this.buffer, t);
                    if (!BufferWithPredicateAndStep.this.until) {
                        if (b) {
                            this.buffer.add(t);
                            continue;
                        }
                        this.ready = true;
                        this.nextBuffer.add(t);
                        continue;
                    }
                    if (b) {
                        this.ready = true;
                    }
                    this.buffer.add(t);
                }
                if (!this.ready) {
                    if (BufferWithPredicateAndStep.this.emitRemainder && !this.buffer.isEmpty()) {
                        this.ready = true;
                    }
                } else {
                    this.ready = true;
                }
            }
        };
    }
}

